/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.config.ConfigManager;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.AbstractSkill;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.skills.conditions.InvalidCondition;
import io.lumine.mythic.core.skills.mechanics.DelaySkill;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class MetaSkill
extends AbstractSkill
implements Skill {
    protected final String file;
    protected final String internalName;
    protected final MythicConfig config;
    protected LinkedList<SkillMechanic> skills = new LinkedList();
    protected List<String> killMessages;

    public MetaSkill(SkillExecutor manager, String file, String name, MythicConfig mc) {
        super(manager);
        SkillCondition sc;
        String ns;
        int i;
        String[] split;
        this.file = file;
        this.internalName = name;
        this.config = mc;
        this.cooldown = (float)mc.getDouble("Cooldown", 0.0);
        List<String> nTConditions = mc.getStringList("Conditions");
        for (String s2 : nTConditions) {
            if (s2.contains("\"")) {
                split = s2.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s2 = ns;
            }
            if ((sc = this.getPlugin().getSkillManager().getCondition(s2)) instanceof InvalidCondition) continue;
            if (this.conditions == null) {
                this.conditions = new ArrayList();
            }
            this.conditions.add(sc);
        }
        nTConditions = mc.getStringList("TargetConditions");
        for (String s2 : nTConditions) {
            if (s2.contains("\"")) {
                split = s2.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s2 = ns;
            }
            if ((sc = this.getPlugin().getSkillManager().getCondition(s2)) instanceof InvalidCondition) continue;
            if (this.conditionsTarget == null) {
                this.conditionsTarget = new ArrayList();
            }
            this.conditionsTarget.add(sc);
        }
        nTConditions = mc.getStringList("TriggerConditions");
        for (String s2 : nTConditions) {
            if (s2.contains("\"")) {
                split = s2.split("\"");
                i = 0;
                ns = "";
                for (String ss : split) {
                    ns = i % 2 == 1 ? ns.concat("\"" + SkillString.unparseMessageSpecialChars(ss) + "\"") : ns.concat(ss);
                    ++i;
                }
                s2 = ns;
            }
            if ((sc = this.getPlugin().getSkillManager().getCondition(s2)) instanceof InvalidCondition) continue;
            if (this.conditionsTrigger == null) {
                this.conditionsTrigger = new ArrayList();
            }
            this.conditionsTrigger.add(sc);
        }
        List<String> nSkills = mc.getStringList("Skills");
        for (String s3 : nSkills) {
            s3 = MythicLineConfigImpl.unparseBlock(s3);
            SkillMechanic ms = null;
            try {
                ms = MythicBukkit.inst().getSkillManager().getMechanic(s3);
            }
            catch (Exception ex) {
                MythicLogger.errorGenericConfig("Critical Error while attempting to load mechanic line '" + s3 + "'");
            }
            catch (Error ex) {
                MythicLogger.errorGenericConfig("Critical Error while attempting to load mechanic line '" + s3 + "'");
            }
            if (ms == null) continue;
            this.skills.add(ms);
        }
    }

    public MetaSkill(SkillExecutor manager, Collection<String> skillList) {
        super(manager);
        this.file = "#\u03bb";
        this.internalName = "#\u03bb." + UUID.randomUUID().toString();
        this.config = null;
        this.cooldown = 0.0f;
        for (String s2 : skillList) {
            s2 = MythicLineConfigImpl.unparseBlock(s2);
            SkillMechanic ms = null;
            try {
                ms = MythicBukkit.inst().getSkillManager().getMechanic(s2);
            }
            catch (Exception ex) {
                MythicLogger.errorGenericConfig("Critical Error while attempting to load mechanic line '" + s2 + "'");
            }
            catch (Error ex) {
                MythicLogger.errorGenericConfig("Critical Error while attempting to load mechanic line '" + s2 + "'");
            }
            if (ms == null) continue;
            this.skills.add(ms);
        }
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isUsable(SkillMetadata data) {
        return this.isUsable(data, null);
    }

    @Override
    public boolean isUsable(SkillMetadata meta, SkillTrigger trigger) {
        SkillCaster skillCaster = meta.getCaster();
        if (!this.rollChance()) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: Roll failed.", new Object[0]);
            return false;
        }
        if (this.onCooldown(skillCaster)) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: Cooldown check failed.", new Object[0]);
            return false;
        }
        if (this.conditionsTarget != null) {
            for (SkillCondition mc : this.conditionsTarget) {
                if (mc.evaluateTargets(meta)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: TargetConditions failed.", new Object[0]);
                return false;
            }
        }
        if (this.conditionsTrigger != null) {
            for (SkillCondition mc : this.conditionsTrigger) {
                if (mc.evaluateTrigger(meta)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: TriggerConditions failed.", new Object[0]);
                return false;
            }
        }
        if (this.conditions != null) {
            for (SkillCondition mc : this.conditions) {
                if (mc.evaluateCaster(meta)) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill not usable: Conditions failed.", new Object[0]);
                return false;
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "! Skill usable!", new Object[0]);
        return true;
    }

    @Override
    public void execute(SkillTrigger basetrigger, SkillCaster caster, AbstractEntity trigger, AbstractLocation origin, HashSet<AbstractEntity> eTargets, HashSet<AbstractLocation> lTargets, float power) {
        SkillMetadataImpl data = new SkillMetadataImpl(basetrigger, caster, trigger, origin, eTargets, lTargets, power);
        this.execute(data);
    }

    @Override
    public void execute(SkillMetadata data) {
        block3: {
            LinkedList skillqueue = (LinkedList)this.skills.clone();
            try {
                if (this.isUsable(data)) {
                    MetaSkill.execute(data, skillqueue);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Couldn't execute skill '" + this.internalName + "': Enable debugging for a stack trace.");
                MythicBukkit.inst().getConfiguration();
                if (ConfigManager.debugLevel <= 0) break block3;
                ex.printStackTrace();
            }
        }
        this.setCooldown(data.getCaster(), this.cooldown);
    }

    public static void execute(SkillMetadata data, Queue<SkillMechanic> skillqueue) {
        while (skillqueue.size() > 0) {
            SkillMechanic mbs = skillqueue.poll();
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "+ Evaluating SkillMechanic {0}", mbs.getConfigLine());
            if (mbs instanceof DelaySkill) {
                AbstractSkill.DelayedSkill ds = new AbstractSkill.DelayedSkill(data, skillqueue);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicBukkit.inst(), (Runnable)ds, (long)((DelaySkill)mbs).getTicks(data));
                break;
            }
            if (!mbs.isUsableFromSkill(data)) continue;
            mbs.execute(data.deepClone());
        }
    }

    public String getFile() {
        return this.file;
    }
}

