/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills;

import io.lumine.mythic.api.skills.SkillTrigger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;

public class SkillTriggers {
    public static final SkillTrigger DEFAULT = SkillTriggers.trigger("DEFAULT", new String[0]);
    public static final SkillTrigger API = SkillTriggers.trigger("API", new String[0]);
    public static final SkillTrigger ATTACK = SkillTriggers.trigger("ATTACK", "HIT");
    public static final SkillTrigger BOW_HIT = SkillTriggers.trigger("BOW_HIT", new String[0]);
    public static final SkillTrigger BLOCK = SkillTriggers.trigger("BLOCK", new String[0]);
    public static final SkillTrigger BLOCK_PLACE = SkillTriggers.trigger("BLOCK_PLACE", "BLOCKPLACE", "PLACEBLOCK", "PLACE_BLOCK");
    public static final SkillTrigger BLOCK_BREAK = SkillTriggers.trigger("BLOCK_BREAK", "BLOCKBREAK", "BREAKBLOCK", "BREAK_BLOCK");
    public static final SkillTrigger COMBAT = SkillTriggers.trigger("COMBAT", new String[0]);
    public static final SkillTrigger CONSUME = SkillTriggers.trigger("CONSUME", "EAT");
    public static final SkillTrigger CROUCH = SkillTriggers.trigger("CROUCH", new String[0]);
    public static final SkillTrigger CREEPER_CHARGE = SkillTriggers.trigger("CREEPER_CHARGE", "CREEPERCHARGE", "CHARGE", "CHARGED");
    public static final SkillTrigger UNCROUCH = SkillTriggers.trigger("UNCROUCH", new String[0]);
    public static final SkillTrigger JUMP = SkillTriggers.trigger("JUMP", new String[0]);
    public static final SkillTrigger DAMAGED = SkillTriggers.trigger("DAMAGED", "HURT");
    public static final SkillTrigger DROPCOMBAT = SkillTriggers.trigger("DROPCOMBAT", "LEAVECOMBAT", "COMBATDROP");
    public static final SkillTrigger DEATH = SkillTriggers.trigger("DEATH", new String[0]);
    public static final SkillTrigger DESPAWNED = SkillTriggers.trigger("DESPAWNED", "DESPAWN");
    public static final SkillTrigger ENTERCOMBAT = SkillTriggers.trigger("ENTERCOMBAT", new String[0]);
    public static final SkillTrigger EXPLODE = SkillTriggers.trigger("EXPLODE", new String[0]);
    public static final SkillTrigger PRIME = SkillTriggers.trigger("PRIME", new String[0]);
    public static final SkillTrigger INTERACT = SkillTriggers.trigger("INTERACT", new String[0]);
    public static final SkillTrigger KILL = SkillTriggers.trigger("KILL", new String[0]);
    public static final SkillTrigger KILLPLAYER = SkillTriggers.trigger("KILLPLAYER", "PLAYERKILL");
    public static final SkillTrigger PLAYERDEATH = SkillTriggers.trigger("PLAYERDEATH", "PLAYERDIE");
    public static final SkillTrigger SHOOT = SkillTriggers.trigger("SHOOT", "BOWSHOOT", "SHOOTBOW");
    public static final SkillTrigger SIGNAL = SkillTriggers.trigger("SIGNAL", new String[0]);
    public static final SkillTrigger SPAWN = SkillTriggers.trigger("SPAWN", new String[0]);
    public static final SkillTrigger SPLASH_POTION = SkillTriggers.trigger("SPLASH_POTION", "POTIONSPLASH", "SPLASHPOTION");
    public static final SkillTrigger SWING = SkillTriggers.trigger("SWING", "LEFTCLICK");
    public static final SkillTrigger TARGETCHANGE = SkillTriggers.trigger("TARGETCHANGE", "CHANGETARGET");
    public static final SkillTrigger TARGETED = SkillTriggers.trigger("TARGETED", new String[0]);
    public static final SkillTrigger TELEPORT = SkillTriggers.trigger("TELEPORT", new String[0]);
    public static final SkillTrigger TIMER = SkillTriggers.trigger("TIMER", new String[0]);
    public static final SkillTrigger USE = SkillTriggers.trigger("USE", new String[0]);
    public static final SkillTrigger RIGHTCLICK = SkillTriggers.trigger("RIGHTCLICK", new String[0]);
    public static final SkillTrigger READY = SkillTriggers.trigger("READY", "FIRSTSPAWN");
    public static final SkillTrigger CAST = SkillTriggers.trigger("CAST", new String[0]);
    public static final SkillTrigger FISH = SkillTriggers.trigger("FISH", "FISHING", "FISHINGCAST");
    public static final SkillTrigger FISH_BITE = SkillTriggers.trigger("FISH_BITE", "FISHBITE", "FISHING_BITE", "FISHINGBITE");
    public static final SkillTrigger FISH_CATCH_FISH = SkillTriggers.trigger("FISHCATCH", "FISHCAUGHT", "FISHINGCATCH", "FISHINGCAUGHT", "CATCHFISH", "CAUGHTFISH");
    public static final SkillTrigger FISH_CATCH_ENTITY = SkillTriggers.trigger("FISHGRAB", "FISHINGGRAB", "FISHENTITY", "FISHINGENTITY");
    public static final SkillTrigger FISH_GROUND = SkillTriggers.trigger("FISH_GROUND", "FISHINGGROUND", "FISHGROUND");
    public static final SkillTrigger FISH_REEL = SkillTriggers.trigger("FISH_REEL", "FISHINGREEL", "FISHREEL");
    public static final SkillTrigger FISH_FAIL = SkillTriggers.trigger("FISH_FAIL", "FISHFAIL", "FISHINGFAIL");
    public static final SkillTrigger TAME = SkillTriggers.trigger("TAME", new String[0]);
    public static final SkillTrigger TAME_FAIL = SkillTriggers.trigger("TAME_FAIL", "TAMEFAIL");
    public static final SkillTrigger TRIDENT_THROW = SkillTriggers.trigger("TRIDENT_THROW", "THROWTRIDENT", "TRIDENTTHROW");
    public static final SkillTrigger TRIDENT_HIT = SkillTriggers.trigger("TRIDENT_HIT", new String[0]);
    public static final SkillTrigger ARMOR_EQUIP = SkillTriggers.trigger("EQUIP", "EQUIPARMOR", "ARMOREQUIP");
    public static final SkillTrigger ARMOR_UNEQUIP = SkillTriggers.trigger("UNEQUIP", "UNEQUIPARMOR", "ARMORUNEQUIP");
    public static final SkillTrigger PRESS_Q = SkillTriggers.trigger("PRESS_Q", "PRESSQ", "DROPITEM");
    public static final SkillTrigger PRESS_CTRLQ = SkillTriggers.trigger("PRESS_CTRL_Q", "PRESSCTRLQ", "PRESS_CTRLQ", "DROPITEMSTACK");
    public static final SkillTrigger PRESS_F = SkillTriggers.trigger("PRESS_F", "ITEMSWAP", "SWAPITEMS");
    public static final SkillTrigger MOUNT = SkillTriggers.trigger("MOUNT", new String[0]);
    public static final SkillTrigger UNMOUNT = SkillTriggers.trigger("UNMOUNT", new String[0]);
    public static final SkillTrigger LOAD = SkillTriggers.trigger("LOAD", new String[0]);
    public static final SkillTrigger CUSTOM = SkillTriggers.trigger("CUSTOM", new String[0]);
    private static final Collection<SkillTrigger> triggers = new HashSet<SkillTrigger>();

    public static SkillTrigger trigger(String name, String ... aliases) {
        return new SkillTrigger(name.toUpperCase(), Arrays.stream(aliases).map(String::toUpperCase).collect(Collectors.toList()));
    }

    public static SkillTrigger trigger(String name, List<String> aliases) {
        return new SkillTrigger(name.toUpperCase(), aliases.stream().map(String::toUpperCase).collect(Collectors.toList()));
    }

    public static void register(SkillTrigger trigger) {
        Validate.notNull((Object)trigger, (String)"Trigger cannot be null");
        triggers.forEach(registeredTrigger -> {
            Validate.isTrue((!registeredTrigger.name().equals(trigger.name()) ? 1 : 0) != 0, (String)("A trigger with name '" + trigger.name() + "' already exists"));
            trigger.aliases().forEach(alias -> Validate.isTrue((!registeredTrigger.name().equals(alias) ? 1 : 0) != 0, (String)("A trigger is already using '" + alias + "' as a name")));
            registeredTrigger.aliases().forEach(alias -> Validate.isTrue((!trigger.aliases().contains(alias) ? 1 : 0) != 0, (String)("A trigger is already using '" + alias + "' as an alias")));
        });
        triggers.add(trigger);
    }

    public static SkillTrigger get(String name) {
        for (SkillTrigger trigger : SkillTriggers.values()) {
            if (trigger.name().equalsIgnoreCase(name)) {
                return trigger;
            }
            if (!trigger.aliases().contains(name.toUpperCase())) continue;
            return trigger;
        }
        return DEFAULT;
    }

    public static Collection<SkillTrigger> values() {
        return triggers;
    }

    static {
        SkillTriggers.register(API);
        SkillTriggers.register(ARMOR_EQUIP);
        SkillTriggers.register(ARMOR_UNEQUIP);
        SkillTriggers.register(ATTACK);
        SkillTriggers.register(BLOCK);
        SkillTriggers.register(BLOCK_BREAK);
        SkillTriggers.register(BLOCK_PLACE);
        SkillTriggers.register(BOW_HIT);
        SkillTriggers.register(CAST);
        SkillTriggers.register(COMBAT);
        SkillTriggers.register(CONSUME);
        SkillTriggers.register(CREEPER_CHARGE);
        SkillTriggers.register(CROUCH);
        SkillTriggers.register(CUSTOM);
        SkillTriggers.register(DAMAGED);
        SkillTriggers.register(DEATH);
        SkillTriggers.register(DEFAULT);
        SkillTriggers.register(DESPAWNED);
        SkillTriggers.register(DROPCOMBAT);
        SkillTriggers.register(ENTERCOMBAT);
        SkillTriggers.register(EXPLODE);
        SkillTriggers.register(FISH);
        SkillTriggers.register(FISH_BITE);
        SkillTriggers.register(FISH_CATCH_ENTITY);
        SkillTriggers.register(FISH_CATCH_FISH);
        SkillTriggers.register(FISH_FAIL);
        SkillTriggers.register(FISH_GROUND);
        SkillTriggers.register(FISH_REEL);
        SkillTriggers.register(INTERACT);
        SkillTriggers.register(JUMP);
        SkillTriggers.register(KILL);
        SkillTriggers.register(KILLPLAYER);
        SkillTriggers.register(LOAD);
        SkillTriggers.register(MOUNT);
        SkillTriggers.register(PLAYERDEATH);
        SkillTriggers.register(PRESS_CTRLQ);
        SkillTriggers.register(PRESS_F);
        SkillTriggers.register(PRESS_Q);
        SkillTriggers.register(PRIME);
        SkillTriggers.register(READY);
        SkillTriggers.register(RIGHTCLICK);
        SkillTriggers.register(SHOOT);
        SkillTriggers.register(SIGNAL);
        SkillTriggers.register(SPAWN);
        SkillTriggers.register(SPLASH_POTION);
        SkillTriggers.register(SWING);
        SkillTriggers.register(TAME);
        SkillTriggers.register(TAME_FAIL);
        SkillTriggers.register(TARGETCHANGE);
        SkillTriggers.register(TARGETED);
        SkillTriggers.register(TELEPORT);
        SkillTriggers.register(TIMER);
        SkillTriggers.register(TRIDENT_HIT);
        SkillTriggers.register(TRIDENT_THROW);
        SkillTriggers.register(UNCROUCH);
        SkillTriggers.register(UNMOUNT);
        SkillTriggers.register(USE);
    }
}

