/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.HashSet;
import java.util.Set;

@MythicCondition(author="Ashijin", name="biome", aliases={}, description="Tests if the target is within the given list of biomes")
public class BiomeCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="biome", aliases={"b"}, description="A list of biomes to check")
    private Set<String> biomes = new HashSet<String>();
    @MythicField(name="exact", aliases={"e"}, description="Whether to match the biome exactly")
    private boolean exact;

    public BiomeCondition(String line, MythicLineConfig mlc) {
        super(line);
        String b = mlc.getString(new String[]{"biome", "b"}, "PLAINS", this.conditionVar);
        for (String s2 : b.split(",")) {
            this.biomes.add(s2.toUpperCase());
        }
        this.exact = mlc.getBoolean(new String[]{"exact", "e"}, true);
    }

    @Override
    public boolean check(AbstractLocation l) {
        String b = l.getBiome().toString().toUpperCase();
        if (this.exact) {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "BiomeCondition checking {0} contains {1}", this.biomes.toString(), b);
            return this.biomes.contains(b);
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "BiomeCondition checking {0} matches {1}", this.biomes.toString(), b);
        for (String biome : this.biomes) {
            if (!b.contains(biome)) continue;
            return true;
        }
        return false;
    }
}

