/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;

@MythicCondition(author="Joikd", name="hasAura", aliases={"hasbuff", "hasdebuff"}, description="Checks if the target entity has the given aura")
public class HasAuraCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="auraName", aliases={"name", "n"}, description="The name of the aura to check for")
    private String auraName;

    public HasAuraCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.auraName = mlc.getString(new String[]{"name", "aura", "auraname", "buffname", "buff", "debuffname", "debuff", "n", "b"}, this.conditionVar, new String[0]);
    }

    @Override
    public boolean check(AbstractEntity target) {
        return HasAuraCondition.getPlugin().getSkillManager().getAuraManager().getAuraRegistry(target).hasAura(this.auraName);
    }
}

