/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.conditions.ICasterCondition;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.utils.numbers.RangedDouble;

@MythicCondition(author="Ashijin", name="level", aliases={}, description="Checks the target MythicMob's level")
public class LevelCondition
extends SkillCondition
implements ICasterCondition,
IEntityCondition {
    @MythicField(name="level", aliases={"l"}, description="The level range to match")
    private RangedDouble data;

    public LevelCondition(String line, MythicLineConfig config) {
        super(line);
        this.data = new RangedDouble(config.getString(new String[]{"level", "l"}, this.conditionVar, new String[0]));
    }

    @Override
    public boolean check(AbstractEntity target) {
        if (MythicBukkit.inst().getMobManager().isActiveMob(target)) {
            ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance(target);
            return this.data.equals(am.getLevel());
        }
        return true;
    }

    @Override
    public boolean check(SkillCaster caster) {
        return this.data.equals(caster.getLevel());
    }
}

