/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;

@MythicCondition(author="Ashijin", name="notInRegion", aliases={}, description="If the target location is not within the given WorldGuard region")
public class NotInRegionCondition
extends SkillCondition
implements ILocationCondition {
    @MythicField(name="region", aliases={"r"}, description="The region name")
    private String regionName;

    public NotInRegionCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.regionName = mlc.getString(new String[]{"region", "r", "name", "n"}, this.conditionVar, new String[0]);
    }

    @Override
    public boolean check(AbstractLocation target) {
        if (!MythicBukkit.inst().getCompatibility().getWorldGuard().isPresent()) {
            return true;
        }
        return !MythicBukkit.inst().getCompatibility().getWorldGuard().get().isLocationInRegions(target, this.regionName);
    }
}

