/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.damage;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.SkillAdapter;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.damage.DamageMetadata;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;

public abstract class DamagingMechanic
extends SkillMechanic {
    protected static boolean noloop = false;
    protected boolean ignoresArmor;
    protected boolean preventImmunity;
    protected boolean preventKnockback;
    protected String element;
    protected String cause;

    public DamagingMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.ignoresArmor = mlc.getBoolean(new String[]{"ignorearmor", "ia", "i"}, false);
        this.preventImmunity = mlc.getBoolean(new String[]{"preventimmunity", "pi"}, false);
        this.preventKnockback = mlc.getBoolean(new String[]{"preventknockback", "pkb", "pk"}, false);
        this.element = mlc.getString(new String[]{"element", "e", "damagetype", "type"}, null, new String[0]);
        this.cause = mlc.getString(new String[]{"damagecause", "dc", "cause"}, "ENTITY_ATTACK", new String[0]);
        if (this.element != null && !MythicBukkit.isVolatile()) {
            MythicLogger.errorMechanicConfig(this, mlc, "Custom damage types require MythicMobs Premium to use.");
            this.element = null;
        }
    }

    protected void doDamage(SkillCaster caster, AbstractEntity target, double amount) {
        DamageMetadata meta = new DamageMetadata(caster, amount, this.element, this.ignoresArmor, this.preventImmunity, this.preventKnockback, this.cause);
        SkillAdapter.get().doDamage(meta, target);
    }
}

