/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.SkillAdapter;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="arrowvolley", description="Shoots a volley of arrows")
public class ArrowVolleyMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected PlaceholderInt amount;
    protected int spread;
    protected int fireTicks;
    protected int removeDelay;
    protected float velocity;

    public ArrowVolleyMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "arrows", "a"}, 20, new String[0]);
        this.spread = mlc.getInteger(new String[]{"spread", "s"}, 45);
        this.fireTicks = mlc.getInteger(new String[]{"fireticks", "ft", "f"}, 0);
        this.velocity = mlc.getFloat(new String[]{"velocity", "v"}, 20.0f);
        this.removeDelay = mlc.getInteger(new String[]{"removedelay", "rd", "r"}, 200);
        this.velocity /= 10.0f;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        SkillAdapter.get().executeVolley(data.getCaster(), target, this.amount.get(data), this.velocity, this.spread, this.fireTicks, this.removeDelay);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        SkillAdapter.get().executeVolley(data.getCaster(), target.getLocation(), this.amount.get(data, target), this.velocity, this.spread, this.fireTicks, this.removeDelay);
        return SkillResult.SUCCESS;
    }
}

