/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.auras.AuraRegistry;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="auraRemove", aliases={"removeaura", "removebuff", "removedebuff"}, description="Removes an aura from the target.")
public class AuraRemoveMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private PlaceholderString auraName;
    private int stacks;
    private boolean matchAny = false;

    public AuraRemoveMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.auraName = mlc.getPlaceholderString(new String[]{"aura", "buff", "debuff", "name", "b", "n"}, "default", new String[0]);
        this.stacks = mlc.getInteger(new String[]{"stacks", "s"}, Integer.MAX_VALUE);
        if (this.auraName.isStatic() && this.auraName.get().equals("ANY")) {
            this.matchAny = true;
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (this.matchAny) {
            int remaining = this.stacks;
            AuraRegistry registry = ((MythicBukkit)this.getPlugin()).getSkillManager().getAuraManager().getAuraRegistry(target);
            for (String name : registry.getAuras().keySet()) {
                int stacks = registry.getStacks(name);
                registry.removeStack(name, stacks);
                if ((remaining -= stacks) > 0) continue;
                break;
            }
        } else {
            ((MythicBukkit)this.getPlugin()).getSkillManager().getAuraManager().getAuraRegistry(target).removeStack(this.auraName.get(data), this.stacks);
        }
        return SkillResult.SUCCESS;
    }
}

