/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractBossBar;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="barSet", version="4.8", description="Sets the display values on a custom bossbar")
public class BarSetMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected String barName;
    protected PlaceholderString barDisplay;
    protected PlaceholderDouble value;
    protected String barTimerColor;
    protected String barTimerStyle;

    public BarSetMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.barName = mlc.getString(new String[]{"name", "n"}, "infobar", new String[0]);
        this.barDisplay = mlc.getPlaceholderString(new String[]{"display", "d", "bartimerdisplay", "bartimertext"}, "<skill.var.aura-name>", new String[0]);
        this.value = mlc.getPlaceholderDouble(new String[]{"value", "v"}, 1.0, new String[0]);
        this.barTimerColor = mlc.getString(new String[]{"color", "c", "bartimercolor"}, null, new String[0]);
        this.barTimerStyle = mlc.getString(new String[]{"style", "s", "bartimerstyle"}, null, new String[0]);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        if (!(data.getCaster() instanceof ActiveMob)) {
            return SkillResult.INVALID_TARGET;
        }
        ActiveMob am = (ActiveMob)data.getCaster();
        AbstractBossBar bar = am.getBar(this.barName);
        if (bar != null) {
            bar.setTitle(this.barDisplay.get(data));
            bar.setProgress(this.value.get(data));
            bar.setColor(this.barTimerColor.toString());
            bar.setStyle(this.barTimerStyle.toString());
        }
        return SkillResult.SUCCESS;
    }
}

