/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.damage.DamagingMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="baseDamage", aliases={"bd", "weaponDamage", "wd"}, description="Deals a percent of the mob's damage stat as damage")
public class BaseDamageMechanic
extends DamagingMechanic
implements ITargetedEntitySkill {
    protected double multiplier;

    public BaseDamageMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.multiplier = mlc.getDouble(new String[]{"multiplier", "m"}, 1.0);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead() || target.getHealth() <= 0.0) {
            return SkillResult.INVALID_TARGET;
        }
        SkillCaster caster = data.getCaster();
        if (caster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)caster;
            if (am.isUsingDamageSkill()) {
                return SkillResult.INVALID_TARGET;
            }
            double damage = am.getDamage() * this.multiplier * (double)data.getPower();
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ BaseDamageMechanic fired for {0} with {1} power", damage, Float.valueOf(data.getPower()));
            this.doDamage(data.getCaster(), target, damage);
        } else {
            double damage = this.multiplier * (double)data.getPower();
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ BaseDamageMechanic fired for {0} with {1} power", damage, Float.valueOf(data.getPower()));
            this.doDamage(data.getCaster(), target, damage);
        }
        return SkillResult.SUCCESS;
    }
}

