/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.utils.version.MinecraftVersions;
import io.lumine.mythic.utils.version.ServerVersion;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

@MythicMechanic(author="Ashijin", name="blockUnmask", aliases={"effect:blockUnmask", "e:blockunmask"}, description="Unmasks any nearby blocks that have been masked")
public class BlockUnmaskEffect
extends SkillMechanic
implements ITargetedLocationSkill {
    private Material mat;
    private int radius;
    private boolean sphere;
    private boolean noAir;
    private int radiusSq;

    public BlockUnmaskEffect(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.radius = mlc.getInteger(new String[]{"radius", "r"}, 0);
        String shape = mlc.getString(new String[]{"shape", "s"}, "SPHERE", new String[0]).toUpperCase();
        this.sphere = shape.equals("SPHERE");
        if (this.radius < 0) {
            this.radius = 0;
        }
        this.radiusSq = this.radius * this.radius;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(target);
        return SkillResult.SUCCESS;
    }

    public void playEffect(AbstractLocation location) {
        Location l = BukkitAdapter.adapt(location);
        if (this.radius == 0) {
            for (Player p : l.getWorld().getPlayers()) {
                if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_13)) {
                    p.sendBlockChange(l, l.getBlock().getBlockData());
                    continue;
                }
                p.sendBlockChange(l, l.getBlock().getType(), l.getBlock().getData());
            }
        } else {
            for (Location ll : this.getBlocksInRadius(l)) {
                for (Player p : l.getWorld().getPlayers()) {
                    if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_13)) {
                        p.sendBlockChange(ll, ll.getBlock().getBlockData());
                        continue;
                    }
                    p.sendBlockChange(ll, ll.getBlock().getType(), ll.getBlock().getData());
                }
            }
        }
    }

    private List<Location> getBlocksInRadius(Location l) {
        ArrayList<Location> blocks = new ArrayList<Location>();
        for (int x = -this.radius; x <= this.radius; ++x) {
            for (int y = -this.radius; y <= this.radius; ++y) {
                for (int z = -this.radius; z <= this.radius; ++z) {
                    Location newloc = new Location(l.getWorld(), l.getX() + (double)x, l.getY() + (double)y, l.getZ() + (double)z);
                    if (this.sphere && l.distanceSquared(newloc) > (double)this.radiusSq) continue;
                    if (this.noAir && !newloc.getBlock().getType().equals((Object)Material.AIR)) {
                        blocks.add(newloc);
                        continue;
                    }
                    if (this.noAir) continue;
                    blocks.add(newloc);
                }
            }
        }
        return blocks;
    }
}

