/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.utils.numbers.Numbers;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;

@MythicMechanic(author="Ashijin", name="blockWave", aliases={"effect:blockWave", "e:blockWave"}, description="Temporarily masks a block as a different block")
public class BlockWaveEffect
extends SkillMechanic
implements ITargetedLocationSkill {
    protected PlaceholderDouble velocity;
    protected PlaceholderDouble velocityH;
    protected PlaceholderDouble velocityX;
    protected PlaceholderDouble velocityY;
    protected PlaceholderDouble velocityZ;
    protected boolean specificVelocities;
    protected PlaceholderInt radius;
    protected PlaceholderInt radiusY;
    protected PlaceholderInt duration;
    protected PlaceholderDouble randomness;
    protected boolean sphere;
    protected Material material;
    protected boolean ignoreAir;
    protected boolean hideSourceBlock;
    private int radiusSq;

    public BlockWaveEffect(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.velocity = mlc.getPlaceholderDouble(new String[]{"velocity", "v"}, 0.2, new String[0]);
        this.velocityH = mlc.getPlaceholderDouble(new String[]{"horizontalvelocity", "velocityh", "vh"}, 0.0, new String[0]);
        this.velocityX = mlc.getPlaceholderDouble(new String[]{"velocityx", "vx"}, 0.0, new String[0]);
        this.velocityY = mlc.getPlaceholderDouble(new String[]{"velocityy", "vy"}, 0.0, new String[0]);
        this.velocityZ = mlc.getPlaceholderDouble(new String[]{"velocityz", "vz"}, 0.0, new String[0]);
        this.radius = mlc.getPlaceholderInteger(new String[]{"radius", "r"}, 2, new String[0]);
        this.radiusY = mlc.getPlaceholderInteger(new String[]{"radiusy", "ry"}, this.radius, new String[0]);
        this.randomness = mlc.getPlaceholderDouble(new String[]{"noise", "n"}, 0.0, new String[0]);
        this.duration = mlc.getPlaceholderInteger(new String[]{"duration", "d"}, 15, new String[0]);
        this.ignoreAir = mlc.getBoolean(new String[]{"ignoreair", "ia"}, true);
        this.hideSourceBlock = mlc.getBoolean(new String[]{"hidesourceblock", "hidesource", "hsb", "hs"}, true);
        String shape = mlc.getString(new String[]{"shape", "s"}, "SPHERE", new String[0]).toUpperCase();
        this.sphere = shape.equals("SPHERE");
        String strMaterial = mlc.getString(new String[]{"material", "m"}, null, new String[0]);
        this.material = strMaterial == null ? null : Material.valueOf((String)strMaterial.toUpperCase());
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        double bv = this.velocity.get(data);
        double bvh = this.velocityH.get(data);
        int radius = this.radius.get(data);
        boolean bl = this.specificVelocities = this.velocityX.get(data) != 0.0 || this.velocityZ.get(data) != 0.0;
        if (radius < 0) {
            radius = 0;
        }
        this.radiusSq = radius * radius;
        if (radius == 0) {
            AbstractVector velocity;
            if (this.specificVelocities) {
                velocity = new AbstractVector(this.velocityX.get(data), this.velocityY.get(data), this.velocityZ.get(data));
            } else {
                double v = -(bv / 2.0) + bv * Numbers.randomDouble();
                double vh = -(bvh / 2.0) + bvh * Numbers.randomDouble();
                velocity = new AbstractVector(vh, v, vh);
            }
            ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getWorldHandler().doBlockTossEffect(target, this.material, velocity, this.duration.get(data), this.hideSourceBlock);
        } else if (this.specificVelocities) {
            AbstractVector velocity = new AbstractVector(this.velocityX.get(data), this.velocityY.get(data), this.velocityZ.get(data));
            for (AbstractLocation l : this.getBlocksInRadius(data, target, true)) {
                ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getWorldHandler().doBlockTossEffect(l, this.material, velocity, this.duration.get(data), this.hideSourceBlock);
            }
        } else {
            for (AbstractLocation l : this.getBlocksInRadius(data, target, true)) {
                double v = -(bv / 2.0) + bv * Numbers.randomDouble();
                double vh = -(bvh / 2.0) + bvh * Numbers.randomDouble();
                ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getWorldHandler().doBlockTossEffect(l, this.material, new AbstractVector(vh, v, vh), this.duration.get(data), this.hideSourceBlock);
            }
        }
        return SkillResult.SUCCESS;
    }

    private List<AbstractLocation> getBlocksInRadius(SkillMetadata data, AbstractLocation location, boolean randomize) {
        int radius = this.radius.get(data);
        int radiusY = this.radiusY.get(data);
        double randomness = this.randomness.get(data);
        ArrayList<AbstractLocation> blocks = new ArrayList<AbstractLocation>();
        Location loc = BukkitAdapter.adapt(location);
        for (int x = -radius; x <= radius; ++x) {
            block1: for (int z = -radius; z <= radius; ++z) {
                for (int y = radiusY; y >= -radiusY; --y) {
                    Location newloc = new Location(loc.getWorld(), (double)(loc.getBlockX() + x), (double)(loc.getBlockY() + y), (double)(loc.getBlockZ() + z));
                    if (this.sphere && loc.distanceSquared(newloc) > (double)this.radiusSq || randomize && randomness > 0.0 && randomness < Numbers.randomDouble() || this.ignoreAir && newloc.getBlock().getType() == Material.AIR) continue;
                    blocks.add(BukkitAdapter.adapt(newloc));
                    continue block1;
                }
            }
        }
        return blocks;
    }
}

