/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.utils.tasks.Scheduler;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@MythicMechanic(author="BerndiVader", version="4.8", name="bloodyScreen", aliases={"effect:bloodyScreen", "e:bloodyScreen", "redScreen", "effect:redScreen", "e:redScreen"}, description="Causes the player's screen to be covered in blood")
public class BloodyScreenEffect
extends SkillMechanic
implements ITargetedEntitySkill {
    private static final AbstractLocation LOCATION = new AbstractLocation(null, 99999.0, 0.0, 99999.0);
    @MythicField(name="duration", aliases={"d"}, version="4.8", description="How long the effect should last")
    private int duration;
    @MythicField(name="cancel", aliases={"c"}, version="4.8", description="If true, will cancel any existing effects immediately")
    private boolean cancel;

    public BloodyScreenEffect(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 0);
        this.cancel = mlc.getBoolean(new String[]{"cancel", "c"}, false);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        Optional<Object> maybeTask = target.getMetadata("bloodyscreeneffect");
        if (maybeTask.isPresent()) {
            CompletableFuture task = (CompletableFuture)maybeTask.get();
            task.cancel(true);
        }
        if (this.cancel) {
            ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setPlayerWorldBorder(target.asPlayer(), null, -1);
            return SkillResult.SUCCESS;
        }
        if (this.duration == 0) {
            ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setPlayerWorldBorder(target.asPlayer(), LOCATION, 1);
        } else {
            ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setPlayerWorldBorder(target.asPlayer(), LOCATION, 1);
            target.setMetadata("bloodyscreeneffect", Scheduler.runLaterSync(() -> {
                if (target.asPlayer().isOnline()) {
                    ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setPlayerWorldBorder(target.asPlayer(), null, -1);
                }
            }, this.duration));
        }
        return SkillResult.SUCCESS;
    }
}

