/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.drops.Drop;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.drops.LootBag;
import io.lumine.mythic.core.drops.droppables.CustomDrop;
import io.lumine.mythic.core.drops.droppables.ItemDrop;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.utils.Schedulers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="breakBlockAndGiveItem", aliases={"blockBreakAndGiveItem"}, description="Breaks the block at the target location")
public class BreakBlockAndGiveItemMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private boolean doDrops;
    private boolean doEffect;
    private boolean useTool;
    private DropTable dropTable;
    private boolean doFakeLooting;

    public BreakBlockAndGiveItemMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.doDrops = mlc.getBoolean(new String[]{"dodrops", "drops", "d"}, true);
        this.doEffect = mlc.getBoolean(new String[]{"doeffect", "effect", "e"}, true);
        this.useTool = mlc.getBoolean(new String[]{"usetool", "tool", "t"}, true);
        this.doFakeLooting = mlc.getBoolean(new String[]{"fakelooting", "fl"}, false);
        String itemString = mlc.getString(new String[]{"items", "item", "i"});
        Optional<DropTable> maybeTable = ((MythicBukkit)this.getPlugin()).getDropManager().getDropTable(itemString);
        if (maybeTable.isPresent()) {
            this.dropTable = maybeTable.get();
            return;
        }
        if (itemString.startsWith("\"")) {
            try {
                itemString = itemString.substring(1, itemString.length() - 1);
            }
            catch (Exception ex) {
                MythicLogger.errorMechanicConfig(this, mlc, "The 'items' attribute is required.");
            }
            itemString = SkillString.parseMessageSpecialChars(itemString);
        }
        ArrayList<String> items = new ArrayList<String>(Arrays.asList(itemString.split(",")));
        this.dropTable = new DropTable("DropItemMechanic", "DropItemMechanic", items);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(data, target.getLocation());
        AbstractEntity caster = data.getCaster().getEntity();
        LootBag loot = this.dropTable.generate(new DropMetadataImpl(data.getCaster(), data.getCaster().getEntity()));
        if (caster.isPlayer()) {
            loot.give(caster.asPlayer(), false);
        }
        if (this.doFakeLooting) {
            if (!caster.isPlayer()) {
                return SkillResult.SUCCESS;
            }
            Player player = (Player)caster.getBukkitEntity();
            for (Drop type : loot.getLootTable()) {
                IDrop drop;
                double amount = type.getAmount();
                if (type instanceof CustomDrop) {
                    if (((CustomDrop)type).getDrop().isEmpty()) continue;
                    drop = ((CustomDrop)type).getDrop().get();
                } else {
                    drop = type;
                }
                if (!(drop instanceof ItemDrop)) continue;
                ItemStack stack = ((BukkitItemStack)((ItemDrop)drop).getDrop(new DropMetadataImpl(data.getCaster(), caster), amount)).build();
                int id = ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().spawnFakeItem(player, stack, target.getLocation());
                Schedulers.sync().runLater(() -> ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().collectFakeItem(player, id), 5L);
            }
        }
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(data, target);
        AbstractEntity caster = data.getCaster().getEntity();
        LootBag loot = this.dropTable.generate(new DropMetadataImpl(data.getCaster(), data.getCaster().getEntity()));
        if (caster.isPlayer()) {
            loot.give(caster.asPlayer(), false);
        }
        if (this.doFakeLooting) {
            if (!caster.isPlayer()) {
                return SkillResult.SUCCESS;
            }
            Player player = (Player)caster.getBukkitEntity();
            for (Drop type : loot.getLootTable()) {
                IDrop drop;
                double amount = type.getAmount();
                if (type instanceof CustomDrop) {
                    if (((CustomDrop)type).getDrop().isEmpty()) continue;
                    drop = ((CustomDrop)type).getDrop().get();
                } else {
                    drop = type;
                }
                if (!(drop instanceof ItemDrop)) continue;
                ItemStack stack = ((BukkitItemStack)((ItemDrop)drop).getDrop(new DropMetadataImpl(data.getCaster(), caster), amount)).build();
                int id = ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().spawnFakeItem(player, stack, target);
                MythicLogger.log("Dropped id " + id + " type " + stack.getType());
                Schedulers.sync().runLater(() -> {
                    MythicLogger.log("Looted " + id + " to " + player.getName());
                    ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().collectFakeItem(player, id);
                }, 5L);
            }
        }
        return SkillResult.SUCCESS;
    }

    public void playEffect(SkillMetadata data, AbstractLocation location) {
        Location l = BukkitAdapter.adapt(location);
        if (this.doDrops) {
            if (this.useTool) {
                ItemStack tool = data.getCaster().getEntity().isPlayer() ? ((Player)data.getCaster().getEntity().getBukkitEntity()).getInventory().getItemInMainHand() : new ItemStack(Material.AIR);
                l.getBlock().breakNaturally(tool);
            } else {
                l.getBlock().breakNaturally();
            }
        } else {
            l.getBlock().setType(Material.AIR);
        }
    }
}

