/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.utils.version.MinecraftVersions;
import io.lumine.mythic.utils.version.ServerVersion;
import org.bukkit.entity.Player;

@MythicMechanic(author="Ashijin", name="command", aliases={"cmd"}, description="Executes a command")
public class CommandMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
INoTargetSkill {
    protected PlaceholderString command;
    protected boolean asCaster;
    protected boolean asTarget;
    protected boolean requireTarget;
    protected boolean asOperator;

    public CommandMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.command = PlaceholderString.of(mlc.getString(new String[]{"command", "cmd", "c"}));
        this.asCaster = mlc.getBoolean(new String[]{"ascaster", "caster", "ac", "sudo", "asmob"}, false);
        this.asTarget = mlc.getBoolean(new String[]{"astarget", "target", "at", "sudotarget"}, false);
        this.requireTarget = mlc.getBoolean(new String[]{"requiretarget", "rt"}, this.asTarget);
        this.asOperator = mlc.getBoolean(new String[]{"asop", "op"}, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        String parsedCommand = this.command.get(data, target);
        if (this.asCaster) {
            if (data.getCaster().getEntity().isPlayer()) {
                Player player = (Player)BukkitAdapter.adapt(data.getCaster().getEntity());
                if (this.asOperator) {
                    boolean op = player.isOp();
                    try {
                        player.setOp(true);
                        player.performCommand(parsedCommand);
                    }
                    finally {
                        player.setOp(op);
                    }
                } else {
                    player.performCommand(parsedCommand);
                }
            } else if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_13)) {
                ((MythicBukkit)this.getPlugin()).getBootstrap().dispatchCommand("minecraft:execute as " + data.getCaster().getEntity().getUniqueId() + " at " + data.getCaster().getEntity().getUniqueId() + " run " + parsedCommand);
            } else {
                ((MythicBukkit)this.getPlugin()).getBootstrap().dispatchCommand("minecraft:execute " + data.getCaster().getEntity().getUniqueId() + " ~ ~ ~ " + parsedCommand);
            }
        } else if (this.asTarget) {
            if (target.isPlayer()) {
                Player player = (Player)BukkitAdapter.adapt(target);
                if (this.asOperator) {
                    boolean op = player.isOp();
                    try {
                        player.setOp(true);
                        player.performCommand(parsedCommand);
                    }
                    finally {
                        player.setOp(op);
                    }
                } else {
                    player.performCommand(parsedCommand);
                }
            } else if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_13)) {
                ((MythicBukkit)this.getPlugin()).getBootstrap().dispatchCommand("minecraft:execute as " + target.getUniqueId() + " at " + target.getUniqueId() + " run " + parsedCommand);
            } else {
                ((MythicBukkit)this.getPlugin()).getBootstrap().dispatchCommand("minecraft:execute " + target.getUniqueId() + " ~ ~ ~ " + parsedCommand);
            }
        } else {
            ((MythicBukkit)this.getPlugin()).getBootstrap().dispatchCommand(parsedCommand);
        }
        return SkillResult.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SkillResult cast(SkillMetadata data) {
        if (this.requireTarget) {
            return SkillResult.INVALID_TARGET;
        }
        String parsedCommand = this.command.get(data);
        if (this.asCaster) {
            if (data.getCaster().getEntity().isPlayer()) {
                Player player = (Player)BukkitAdapter.adapt(data.getCaster().getEntity());
                if (this.asOperator) {
                    boolean op = player.isOp();
                    try {
                        player.setOp(true);
                        player.performCommand(parsedCommand);
                    }
                    finally {
                        player.setOp(op);
                    }
                } else {
                    player.performCommand(parsedCommand);
                }
            } else if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_13)) {
                ((MythicBukkit)this.getPlugin()).getBootstrap().dispatchCommand("minecraft:execute as " + data.getCaster().getEntity().getUniqueId() + " at " + data.getCaster().getEntity().getUniqueId() + " run " + parsedCommand);
            } else {
                ((MythicBukkit)this.getPlugin()).getBootstrap().dispatchCommand("minecraft:execute " + data.getCaster().getEntity().getUniqueId() + " ~ ~ ~ " + parsedCommand);
            }
        } else {
            ((MythicBukkit)this.getPlugin()).getBootstrap().dispatchCommand(parsedCommand);
        }
        return SkillResult.SUCCESS;
    }
}

