/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Phil", name="consumeslotitem", aliases={"consumeslot"}, description="Removes an amount of the target's item in a specified slot")
public class ConsumeSlotItemMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private String slot;
    private PlaceholderInt amount;

    public ConsumeSlotItemMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.slot = mlc.getString(new String[]{"slot", "s"}, "HAND", new String[0]);
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 1, new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        ItemStack item;
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        Player player = BukkitAdapter.adapt(target.asPlayer());
        try {
            int slot = Integer.parseInt(this.slot);
            item = slot < 36 ? player.getInventory().getItem(slot) : player.getInventory().getItem(0);
        }
        catch (NumberFormatException ex) {
            switch (EquipSlot.of(this.slot)) {
                case OFFHAND: {
                    item = player.getInventory().getItemInOffHand();
                    break;
                }
                case HEAD: {
                    item = player.getInventory().getHelmet();
                    break;
                }
                case FEET: {
                    item = player.getInventory().getBoots();
                    break;
                }
                case LEGS: {
                    item = player.getInventory().getLeggings();
                    break;
                }
                case CHEST: {
                    item = player.getInventory().getChestplate();
                    break;
                }
                default: {
                    item = player.getInventory().getItemInMainHand();
                }
            }
        }
        if (item != null) {
            int newAmount = item.getAmount() - this.amount.get(data, target);
            if (newAmount <= 0) {
                ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().destroyItem(item);
                player.updateInventory();
                if (MythicBukkit.inst().getCompatibility().getArtifacts().isPresent()) {
                    MythicBukkit.inst().getCompatibility().getArtifacts().get().reparseWeapon(data.getCaster().getEntity().asPlayer());
                }
            } else {
                item.setAmount(newAmount);
            }
        }
        return SkillResult.SUCCESS;
    }
}

