/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="feed", description="Feeds the target entity")
public class FeedSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderInt amount;
    protected float saturation;
    protected boolean overfeed;

    public FeedSkill(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 1, new String[0]);
        this.saturation = mlc.getFloat(new String[]{"saturation", "s"}, 0.0f);
        this.overfeed = mlc.getBoolean(new String[]{"overfeed", "of", "o"}, false);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead() || !target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        int currentFood = target.asPlayer().getFoodLevel();
        int food = currentFood + this.amount.get(data, target);
        float saturation = target.asPlayer().getFoodSaturation() + this.saturation;
        if (food >= 20) {
            if (this.overfeed) {
                target.asPlayer().setFoodLevel(food);
                if (saturation > (float)food) {
                    saturation = food;
                }
            } else {
                target.asPlayer().setFoodLevel(20);
                if (saturation > 20.0f) {
                    saturation = 20.0f;
                }
            }
        } else {
            target.asPlayer().setFoodLevel(food);
            if (!this.overfeed && saturation > (float)food) {
                saturation = food;
            }
        }
        target.asPlayer().setFoodSaturation(saturation);
        return SkillResult.SUCCESS;
    }
}

