/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="freeze", description="Chills the target entity")
public class FreezeMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderInt ticks;

    public FreezeMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.ticks = mlc.getPlaceholderInteger(new String[]{"ticks", "t", "duration", "d"}, 60, new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isValid()) {
            return SkillResult.INVALID_TARGET;
        }
        int freezingticks = this.ticks.get(data, target);
        target.setFreezingTicks(Math.min(freezingticks, target.getMaxFreezingTicks()));
        return SkillResult.SUCCESS;
    }
}

