/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="gcd", aliases={"globalcooldown", "setgcd", "setglobalcooldown"}, description="Triggers the global cooldown for the caster")
public class GCDMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected PlaceholderInt ticks;

    public GCDMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.ticks = mlc.getPlaceholderInteger(new String[]{"ticks", "t"}, 20, new String[0]);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        data.getCaster().setGlobalCooldown(this.ticks.get(data));
        return SkillResult.SUCCESS;
    }
}

