/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="goto", aliases={"pathto", "navigateto"}, description="Path to the target location")
public class GoToMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected PlaceholderDouble maxDistance;
    protected PlaceholderDouble spreadH;
    protected PlaceholderDouble spreadV;
    private boolean isStatic;

    public GoToMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.maxDistance = mlc.getPlaceholderDouble(new String[]{"maxdistance", "md"}, 64.0, new String[0]);
        this.spreadH = mlc.getPlaceholderDouble(new String[]{"spreadh", "sh"}, 0.0, new String[0]);
        this.spreadV = mlc.getPlaceholderDouble(new String[]{"spreadv", "sv"}, 0.0, new String[0]);
        this.isStatic = this.spreadH.isStaticallyEqualTo(0.0) && this.spreadV.isStaticallyEqualTo(0.0);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.castAtLocation(data, target.getLocation());
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        if (!this.isStatic) {
            double spreadH = this.spreadH.get(data);
            double spreadV = this.spreadV.get(data);
            if (data.getCaster() instanceof ActiveMob) {
                ActiveMob am = (ActiveMob)data.getCaster();
                ((MythicBukkit)this.getPlugin()).getMobManager();
                target = MobExecutor.findSafeSpawnLocation(target, (int)spreadH, (int)spreadV, am.getType().getMythicEntity().getHeight() + 1);
            } else {
                ((MythicBukkit)this.getPlugin()).getMobManager();
                target = MobExecutor.findSafeSpawnLocation(target, (int)spreadH, (int)spreadV, 2);
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Pathing to {0}", target.toString());
        ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getAIHandler().navigateToLocation(data.getCaster().getEntity(), target, this.maxDistance.get(data));
        return SkillResult.SUCCESS;
    }
}

