/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="heal", aliases={"h"}, description="Heals the target entity")
public class HealMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderDouble amount;
    protected boolean overheal;
    protected PlaceholderDouble maxOverheal;

    public HealMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        String strAmount = mlc.getString(new String[]{"amount", "a"}, "1", new String[0]);
        this.amount = PlaceholderDouble.of(strAmount);
        this.overheal = mlc.getBoolean(new String[]{"overheal", "oh"}, false);
        this.maxOverheal = PlaceholderDouble.of(mlc.getString(new String[]{"maxoverheal", "maxabsorb", "maxshield", "mo", "ma", "ms"}, strAmount, new String[0]));
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead()) {
            return SkillResult.INVALID_TARGET;
        }
        double health = target.getHealth() + this.amount.get(data, target);
        if (health >= target.getMaxHealth()) {
            if (this.overheal) {
                double diff = health - target.getMaxHealth();
                double absorb = (double)MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().getEntityAbsorptionHearts(target) + diff;
                if (absorb < this.maxOverheal.get(data, target)) {
                    MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().setEntityAbsorptionHearts(target, (float)absorb);
                }
            }
            target.setHealth(target.getMaxHealth());
        } else {
            target.setHealth(health);
        }
        return SkillResult.SUCCESS;
    }
}

