/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="healpercent", aliases={"percentheal", "hp"}, description="Heals the target entity for a percentage of their health")
public class HealPercentMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderDouble multiplier;
    protected boolean overheal;
    protected PlaceholderDouble maxOverheal;

    public HealPercentMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.multiplier = mlc.getPlaceholderDouble(new String[]{"multiplier", "m"}, 0.1, new String[0]);
        this.overheal = mlc.getBoolean("overheal", false);
        this.maxOverheal = mlc.getPlaceholderDouble(new String[]{"maxoverheal", "maxabsorb", "maxshield", "mo", "ma", "ms"}, 0.0, new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead()) {
            return SkillResult.INVALID_TARGET;
        }
        double heal = target.getMaxHealth() * this.multiplier.get(data, target);
        double health = target.getHealth() + heal;
        if (health >= target.getMaxHealth()) {
            if (this.overheal) {
                double max = target.getMaxHealth() * this.maxOverheal.get(data, target);
                double diff = health - target.getMaxHealth();
                double absorb = (double)MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().getEntityAbsorptionHearts(target) + diff;
                if (absorb < max) {
                    MythicBukkit.inst().getVolatileCodeHandler().getEntityHandler().setEntityAbsorptionHearts(target, (float)absorb);
                }
            }
            target.setHealth(target.getMaxHealth());
        } else {
            if (health < 0.0) {
                health = 0.0;
            }
            target.setHealth(health);
        }
        return SkillResult.SUCCESS;
    }
}

