/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.utils.Schedulers;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@MythicMechanic(author="Phil", name="hideFromPlayers", aliases={"hideFromPlayer", "hide"}, description="Hides the (Player) caster from the targeted player(s) for a duration")
public class HideFromPlayersMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private PlaceholderInt duration;
    private Integer time;

    public HideFromPlayersMechanic(SkillExecutor manager, String skill, MythicLineConfig config) {
        super(manager, skill, config);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.duration = config.getPlaceholderInteger(new String[]{"duration", "ticks", "d", "t"}, 100, new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer() || target.getUniqueId() == data.getCaster().getEntity().getUniqueId()) {
            return SkillResult.INVALID_TARGET;
        }
        this.time = this.duration.get(data) <= 0 ? Integer.valueOf(100) : Integer.valueOf(this.duration.get(data));
        this.hideMe(data, target, this.time);
        return SkillResult.SUCCESS;
    }

    public void hideMe(SkillMetadata data, AbstractEntity target, Integer duration) {
        Player player = (Player)target.getBukkitEntity();
        Player caster = BukkitAdapter.adapt(data.getCaster().getEntity().asPlayer());
        player.hidePlayer((Plugin)this.getPlugin(), caster);
        if (duration != null) {
            Schedulers.sync().runLater(() -> player.showPlayer((Plugin)this.getPlugin(), caster), duration.intValue());
        }
    }
}

