/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.SkillAdapter;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="effect:lightning", aliases={"e:lightning"}, description="Causes a lightning strike effect at the target location")
public class LightningEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected boolean localized;
    protected double localizedRadius = 128.0;

    public LightningEffect(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.localized = mlc.getBoolean(new String[]{"localized", "l"}, false);
        this.localizedRadius = mlc.getDouble(new String[]{"localizedradius", "lr", "r"}, 128.0);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        if (this.localized) {
            ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getEntityHandler().spawnFakeLightning(target, this.localizedRadius);
        } else {
            SkillAdapter.get().strikeLightningEffect(target);
        }
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.castAtLocation(data, target.getLocation());
    }
}

