/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="lunge", description="Causes the caster to lunge forward at the target")
public class LungeMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected PlaceholderDouble velocity;
    protected PlaceholderDouble velocityY;

    public LungeMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.velocity = mlc.getPlaceholderDouble(new String[]{"velocity", "v", "magnitude"}, 1.0, new String[0]);
        this.velocityY = mlc.getPlaceholderDouble(new String[]{"velocityy", "yvelocity", "vy", "yv"}, 0.01337f, new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.castAtLocation(data, target.getLocation());
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        double velocity = Math.abs(this.velocity.get(data));
        double velocityY = this.velocityY.get(data);
        AbstractLocation cL = data.getCaster().getEntity().getLocation();
        if (cL.distance2DSquared(target) == 0.0) {
            target = target.add(cL.getDirection().normalize().multiply(2));
        }
        AbstractVector v = target.toVector().subtract(cL.toVector()).normalize();
        if (velocityY != 0.01337) {
            v.setY(velocityY);
        }
        if ((v = v.multiply(velocity)).length() > 4.0) {
            v = v.normalize().multiply(4);
        }
        data.getCaster().getEntity().setVelocity(v);
        return SkillResult.SUCCESS;
    }
}

