/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillAudience;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.Collection;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="message", aliases={"msg", "m"}, description="Sends a message to the target entity")
public class MessageMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    private SkillAudience audience;
    protected PlaceholderString message;

    public MessageMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.target_creative = true;
        try {
            this.message = mlc.getPlaceholderString(new String[]{"message", "msg", "m"}, null, new String[0]);
        }
        catch (Exception ex) {
            this.message = null;
            ex.printStackTrace();
        }
        if (this.message == null) {
            MythicLogger.errorMechanicConfig(this, mlc, "The 'message' attribute is required.");
            this.message = PlaceholderString.of("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.");
            return;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded message skill with message {0}", this.message.toString());
        this.audience = mlc.getAudience("audience", null);
        String targeter = mlc.getString(new String[]{"target", "t", "at"}, null, new String[0]);
        if (targeter != null) {
            SkillTargeter t2 = this.parseSkillTargeter(targeter);
            if (t2 == null) {
                MythicLogger.errorMechanicConfig(this, mlc, "Targeter was not found.");
            } else if (t2 instanceof IEntitySelector) {
                this.targeter = Optional.ofNullable((IEntitySelector)t2);
            } else {
                MythicLogger.errorMechanicConfig(this, mlc, "Targeter must an entity targeter.");
            }
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (this.audience != null) {
            String message = this.message.get(data, target);
            Collection<AbstractEntity> audience = this.audience.get(data, target);
            for (AbstractEntity at : audience) {
                if (!at.isPlayer()) continue;
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Sending message {0} to ", this.message, at.getName());
                at.asPlayer().sendMessage(message);
            }
            return SkillResult.SUCCESS;
        }
        if (target.isPlayer()) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Sending message {0}", this.message);
            target.asPlayer().sendMessage(this.message.get(data, target));
            return SkillResult.SUCCESS;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Failed to send message to non-player", new Object[0]);
        return SkillResult.INVALID_TARGET;
    }
}

