/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.utils.Events;
import java.util.Optional;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

@MythicMechanic(author="Phil", name="OnSwing", aliases={"OnLeftClick"})
public class OnLeftClickMechanic
extends Aura
implements ITargetedEntitySkill {
    private String onSwingSkillName;
    private Optional<Skill> onSwingSkill = Optional.empty();

    public OnLeftClickMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.onSwingSkillName = mlc.getString(new String[]{"onswingskill", "onswing", "osw"});
        MythicBukkit.inst().getSkillManager().queueSecondPass(() -> {
            if (this.onSwingSkillName != null) {
                this.onSwingSkill = MythicBukkit.inst().getSkillManager().getSkill(this.onSwingSkillName);
            }
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Tracker(target, data);
        return SkillResult.SUCCESS;
    }

    private class Tracker
    extends Aura.AuraTracker
    implements IParentSkill,
    Runnable {
        public Tracker(AbstractEntity entity, SkillMetadata data) {
            super((Aura)OnLeftClickMechanic.this, entity, data);
            this.start();
        }

        @Override
        public void auraStart() {
            this.registerAuraComponent(Events.subscribe(PlayerInteractEvent.class).filter(event -> event.getPlayer().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())).filter(event -> event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK).filter(event -> event.getHand() == EquipmentSlot.HAND).handler(event -> {
                SkillMetadata meta = this.skillMetadata.deepClone();
                if (this.executeAuraSkill(OnLeftClickMechanic.this.onSwingSkill, meta)) {
                    this.consumeCharge();
                }
            }));
            this.executeAuraSkill(OnLeftClickMechanic.this.onStartSkill, this.skillMetadata);
        }
    }
}

