/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.adapters.BukkitParticle;
import io.lumine.mythic.core.skills.ParticleMaker;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ParticleEffect;
import io.lumine.mythic.core.utils.RandomUtil;
import io.lumine.mythic.core.utils.VectorUtils;
import io.lumine.mythic.utils.numbers.Numbers;
import io.lumine.mythic.utils.tasks.Scheduler;
import io.lumine.mythic.utils.version.MinecraftVersions;
import io.lumine.mythic.utils.version.ServerVersion;
import java.util.Collection;
import java.util.Optional;

public class ParticleAtomEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected String particleNucleus;
    protected String particleOrbital;
    protected BukkitParticle pNucleus;
    protected Object pNucleusData = null;
    protected float radiusN;
    protected int radius;
    protected int amountN;
    protected int amountO;
    protected int orbitals;
    protected int rotation;
    protected int interval;
    protected int iterations;
    protected double velocity = 1.0;
    protected double angularVelocity = 0.039269908169872414;

    public ParticleAtomEffect(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.ASYNC_ONLY;
        this.particleOrbital = mlc.getString("particleorbital", this.strParticle);
        this.particleOrbital = mlc.getString("particleo", this.particleOrbital);
        this.particleOrbital = mlc.getString("po", this.particleOrbital);
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            this.particle = BukkitParticle.get(this.particleOrbital);
            if (this.particle.requiresData()) {
                this.particleData = this.particle.parseDataOptions(mlc);
            }
        }
        this.particleNucleus = mlc.getString("particlenucleus", "reddust");
        this.particleNucleus = mlc.getString("particlen", this.particleNucleus);
        this.particleNucleus = mlc.getString("pn", this.particleNucleus);
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            this.pNucleus = BukkitParticle.get(this.particleNucleus);
            if (this.pNucleus.requiresData()) {
                this.pNucleusData = this.pNucleus.parseDataOptions(mlc);
            }
        }
        this.amountN = mlc.getInteger("amountnucleus", 50);
        this.amountN = mlc.getInteger("amountn", this.amountN);
        this.amountN = mlc.getInteger("apn", this.amountN);
        this.amountN = mlc.getInteger("an", this.amountN);
        this.amount = mlc.getPlaceholderInteger(new String[]{"amountorbital", "amounto", "apo", "ao"}, 1, new String[0]);
        this.orbitals = mlc.getInteger("orbitals", 2);
        this.orbitals = mlc.getInteger("o", this.orbitals);
        this.radius = mlc.getInteger("radius", 4);
        this.radius = mlc.getInteger("r", this.radius);
        this.radiusN = mlc.getFloat("radiusnucleus", 1.0f);
        this.radiusN = mlc.getFloat("rn", this.radiusN);
        this.rotation = mlc.getInteger("rotation", 0);
        this.rotation = mlc.getInteger("ro", this.rotation);
        this.iterations = mlc.getInteger("ticks", 1);
        this.iterations = mlc.getInteger("t", this.iterations);
        this.interval = mlc.getInteger("interval", 10);
        this.interval = mlc.getInteger("in", this.interval);
        this.velocity = mlc.getDouble(new String[]{"velocity", "v"}, 80.0);
        this.angularVelocity = Math.PI / this.velocity;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        new Animator(data, target);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Animator(data, target);
        return SkillResult.SUCCESS;
    }

    protected void playNucleusParticleEffect(SkillMetadata data, AbstractLocation target, Collection<AbstractEntity> audience) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            if (this.pNucleusData == null) {
                if (this.color != null) {
                    this.pNucleus.sendLegacyColored(audience, target, this.pSpeed.get(data), this.amountN, this.xSpread.get(data), this.vSpread.get(data), this.zSpread.get(data), this.color);
                } else {
                    this.pNucleus.send(audience, target, this.pSpeed.get(data), this.amountN, this.xSpread.get(data), this.vSpread.get(data), this.zSpread.get(data));
                }
            } else {
                this.pNucleus.send(audience, target, this.pSpeed.get(data), this.amountN, this.xSpread.get(data), this.vSpread.get(data), this.zSpread.get(data), this.pNucleusData, this.exactOffsets);
            }
        } else {
            if (this.color != null) {
                for (int i = 0; i < this.amountN; ++i) {
                    AbstractLocation ln = target.clone().add((double)(0.0f - this.xSpread.get(data)) + Numbers.randomDouble() * (double)this.xSpread.get(data) * 2.0, (double)(this.yOffset.get(data) - this.vSpread.get(data)) + Numbers.randomDouble() * (double)this.vSpread.get(data) * 2.0, (double)(0.0f - this.zSpread.get(data)) + Numbers.randomDouble() * (double)this.zSpread.get(data) * 2.0);
                    new ParticleMaker.ParticlePacket(this.particleNucleus, this.color, this.pSpeed.get(data), 1, true).send(ln, this.viewDistance);
                }
                return;
            }
            new ParticleMaker.ParticlePacket(this.particleNucleus, this.xSpread.get(data), this.vSpread.get(data), this.zSpread.get(data), this.pSpeed.get(data), this.amountN, true).send(target, this.viewDistance);
        }
    }

    private class Animator
    implements Runnable {
        private SkillMetadata data;
        private Optional<AbstractEntity> entity = Optional.empty();
        private Optional<AbstractLocation> location = Optional.empty();
        private int iteration = 0;
        private int step = 0;
        private Scheduler.Task task;

        public Animator(SkillMetadata data, AbstractEntity entity) {
            this.data = data;
            this.entity = Optional.of(entity);
            this.task = Scheduler.runTaskRepeatingAsync(this, 0L, (long)ParticleAtomEffect.this.interval);
        }

        public Animator(SkillMetadata data, AbstractLocation location) {
            this.data = data;
            this.location = Optional.of(location);
            this.task = Scheduler.runTaskRepeatingAsync(this, 0L, (long)ParticleAtomEffect.this.interval);
        }

        public AbstractLocation getLocation() {
            if (this.entity.isPresent()) {
                return this.entity.get().getLocation();
            }
            return this.location.get();
        }

        @Override
        public void run() {
            int i;
            AbstractLocation location = this.getLocation();
            Collection<AbstractEntity> audience = ParticleAtomEffect.this.audience.get(this.data, this.entity.orElseGet(() -> null));
            for (i = 0; i < ParticleAtomEffect.this.amountN; ++i) {
                AbstractVector v = RandomUtil.getRandomVector().multiply((float)ParticleAtomEffect.this.radius * ParticleAtomEffect.this.radiusN);
                location.add(v);
                ParticleAtomEffect.this.playNucleusParticleEffect(this.data, location, audience);
                location.subtract(v);
            }
            for (i = 0; i < ParticleAtomEffect.this.amountO; ++i) {
                double angle = (double)this.step * ParticleAtomEffect.this.angularVelocity;
                for (int j = 0; j < ParticleAtomEffect.this.orbitals; ++j) {
                    double xRotation = Math.PI / (double)ParticleAtomEffect.this.orbitals * (double)j;
                    AbstractVector v = new AbstractVector(Math.cos(angle), Math.sin(angle), 0.0).multiply(ParticleAtomEffect.this.radius);
                    VectorUtils.rotateAroundAxisX(v, xRotation);
                    VectorUtils.rotateAroundAxisY(v, (double)ParticleAtomEffect.this.rotation);
                    location.add(v);
                    ParticleAtomEffect.this.playParticleEffect(this.data, location, audience);
                    location.subtract(v);
                }
                ++this.step;
            }
            if (++this.iteration * ParticleAtomEffect.this.interval >= ParticleAtomEffect.this.iterations) {
                this.task.terminate();
            }
        }
    }
}

