/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.adapters.BukkitParticle;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.ParticleMaker;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ParticleEffect;
import io.lumine.mythic.core.utils.RandomUtil;
import io.lumine.mythic.utils.Schedulers;
import io.lumine.mythic.utils.tasks.Task;
import io.lumine.mythic.utils.version.MinecraftVersions;
import io.lumine.mythic.utils.version.ServerVersion;
import java.util.ArrayList;
import java.util.Collection;

public class ParticleTornadoEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    float cloudHSpread;
    float cloudVSpread;
    float cloudPSpeed;
    float cloudYOffset;
    public String strCloudParticle = "cloud";
    protected BukkitParticle cloudParticle;
    protected Object cloudParticleData = null;
    public float cloudSize = 2.5f;
    public float particleSpeedRamp = 0.0f;
    public int cloudAmount = 1;
    public double yOffset = 0.8;
    public float tornadoHeight = 5.0f;
    public float maxTornadoRadius = 5.0f;
    private int sliceHeight;
    private int interval;
    private int duration;
    private float rotationSpeed;
    public boolean showCloud = true;
    public boolean showTornado = true;
    private boolean stopOnCasterDeath = true;
    private boolean stopOnEntityDeath = true;
    public double distance = 0.375;

    public ParticleTornadoEffect(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.ASYNC_ONLY;
        this.maxTornadoRadius = mlc.getFloat(new String[]{"maxradius", "mr"}, 3.0f);
        this.yOffset = mlc.getFloat(new String[]{"yoffset", "yo"}, 0.8f);
        this.tornadoHeight = mlc.getFloat(new String[]{"height", "h"}, 4.0f);
        this.interval = mlc.getInteger(new String[]{"interval", "i"}, 4);
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 200);
        this.rotationSpeed = mlc.getFloat(new String[]{"rotationspeed", "rs"}, 0.04f);
        this.sliceHeight = mlc.getInteger(new String[]{"sliceheight", "sh"}, 64);
        this.particleSpeedRamp = mlc.getFloat(new String[]{"particlespeedramp", "psr"}, 0.0f);
        this.stopOnCasterDeath = mlc.getBoolean(new String[]{"stoponcasterdeath", "scd"}, true);
        this.stopOnEntityDeath = mlc.getBoolean(new String[]{"stoponentitydeath", "sed"}, true);
        this.strCloudParticle = mlc.getString(new String[]{"cloudparticle", "cp"}, "largeexplode", new String[0]);
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            this.cloudParticle = BukkitParticle.get(this.strCloudParticle);
            if (this.cloudParticle.requiresData()) {
                this.cloudParticleData = this.cloudParticle.parseDataOptions(mlc);
            }
        }
        this.cloudSize = mlc.getFloat(new String[]{"cloudsize", "cs"}, 5.0f);
        this.cloudAmount = mlc.getInteger(new String[]{"cloudamount", "ca"}, 1);
        this.cloudHSpread = mlc.getFloat(new String[]{"cloudhspread", "chs"}, 1.0f);
        this.cloudVSpread = mlc.getFloat(new String[]{"cloudvspread", "cvs"}, 1.8f);
        this.cloudPSpeed = mlc.getFloat(new String[]{"cloudpspeed", "cps", "cs"}, 2.0f);
        this.cloudYOffset = mlc.getFloat(new String[]{"cloudyoffset", "cyo"}, 1.8f);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        new Animator(data, target, this.interval, this.duration);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Animator(data, target, this.interval, this.duration);
        return SkillResult.SUCCESS;
    }

    public ArrayList<AbstractVector> createCircle(double y, double radius, double rotation) {
        double amount = radius * (double)this.sliceHeight;
        double inc = Math.PI * 2 / amount;
        double r = rotation % 360.0;
        ArrayList<AbstractVector> vecs = new ArrayList<AbstractVector>();
        int i = 0;
        while ((double)i < amount) {
            double angle = (double)i * inc + r;
            double x = radius * Math.cos(angle);
            double z = radius * Math.sin(angle);
            AbstractVector v = new AbstractVector(x, y, z);
            vecs.add(v);
            ++i;
        }
        return vecs;
    }

    private class Animator
    implements Runnable {
        private SkillMetadata data;
        private AbstractEntity entity;
        private AbstractLocation location;
        private int interval;
        private int duration;
        private int iteration;
        private Task task;

        public Animator(SkillMetadata data, AbstractLocation location, int interval, int duration) {
            this(interval, duration);
            this.data = data;
            this.entity = null;
            this.location = location;
        }

        public Animator(SkillMetadata data, AbstractEntity entity, int interval, int duration) {
            this(interval, duration);
            this.data = data;
            this.entity = entity;
        }

        protected Animator(int interval, int duration) {
            this.interval = interval;
            this.duration = duration;
            this.iteration = 0;
            this.task = Schedulers.async().runRepeating(this, 0L, (long)interval);
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Started ParticleTornado effect", new Object[0]);
        }

        protected AbstractLocation getLocation() {
            if (this.entity != null) {
                return this.entity.getLocation();
            }
            return this.location.clone();
        }

        @Override
        public void run() {
            if (ParticleTornadoEffect.this.stopOnEntityDeath && this.entity != null && this.entity.isDead()) {
                this.task.terminate();
            } else if (ParticleTornadoEffect.this.stopOnCasterDeath && this.data.getCaster().getEntity().isDead()) {
                this.task.terminate();
            } else if (this.iteration * this.interval > this.duration) {
                this.task.terminate();
            } else {
                ++this.iteration;
                AbstractLocation l = this.getLocation().add(0.0, ParticleTornadoEffect.this.cloudYOffset, 0.0);
                int i = 0;
                while ((float)i < ParticleTornadoEffect.this.cloudSize) {
                    AbstractVector v = RandomUtil.getRandomCircleVector().multiply(RandomUtil.random.nextDouble() * (double)ParticleTornadoEffect.this.cloudSize);
                    if (ParticleTornadoEffect.this.showCloud) {
                        l.add(v);
                        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
                            Collection<AbstractEntity> audience = ParticleTornadoEffect.this.audience.get(this.data, this.entity);
                            if (ParticleTornadoEffect.this.particleData == null) {
                                if (ParticleTornadoEffect.this.color != null) {
                                    ParticleTornadoEffect.this.cloudParticle.sendLegacyColored(audience, l, ParticleTornadoEffect.this.cloudPSpeed, ParticleTornadoEffect.this.cloudAmount, ParticleTornadoEffect.this.cloudHSpread, ParticleTornadoEffect.this.cloudVSpread, ParticleTornadoEffect.this.cloudHSpread, ParticleTornadoEffect.this.color);
                                } else {
                                    ParticleTornadoEffect.this.cloudParticle.send(audience, l, ParticleTornadoEffect.this.cloudPSpeed, ParticleTornadoEffect.this.cloudAmount, ParticleTornadoEffect.this.cloudHSpread, ParticleTornadoEffect.this.cloudVSpread, ParticleTornadoEffect.this.cloudHSpread);
                                }
                            } else {
                                ParticleTornadoEffect.this.cloudParticle.send(audience, l, ParticleTornadoEffect.this.cloudPSpeed, ParticleTornadoEffect.this.cloudAmount, ParticleTornadoEffect.this.cloudHSpread, ParticleTornadoEffect.this.cloudVSpread, ParticleTornadoEffect.this.cloudHSpread, ParticleTornadoEffect.this.cloudParticleData, ParticleTornadoEffect.this.exactOffsets);
                            }
                        } else {
                            new ParticleMaker.ParticlePacket(ParticleTornadoEffect.this.strCloudParticle, ParticleTornadoEffect.this.cloudHSpread, ParticleTornadoEffect.this.cloudVSpread, ParticleTornadoEffect.this.cloudHSpread, ParticleTornadoEffect.this.cloudPSpeed, ParticleTornadoEffect.this.cloudAmount, true).send(l, ParticleTornadoEffect.this.viewDistance);
                        }
                        l.subtract(v);
                    }
                    ++i;
                }
                AbstractLocation t2 = l.clone().add(0.0, 0.2 + ParticleTornadoEffect.this.yOffset, 0.0);
                double r = 0.45 * ((double)ParticleTornadoEffect.this.maxTornadoRadius * (2.35 / (double)ParticleTornadoEffect.this.tornadoHeight));
                for (double y = 0.0; y < (double)ParticleTornadoEffect.this.tornadoHeight; y += ParticleTornadoEffect.this.distance) {
                    double fr = r * y;
                    if (fr > (double)ParticleTornadoEffect.this.maxTornadoRadius) {
                        fr = ParticleTornadoEffect.this.maxTornadoRadius;
                    }
                    for (AbstractVector v : ParticleTornadoEffect.this.createCircle(y, fr, (double)this.iteration * (double)this.interval * (double)ParticleTornadoEffect.this.rotationSpeed)) {
                        if (!ParticleTornadoEffect.this.showTornado) continue;
                        l.add(v);
                        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
                            Collection<AbstractEntity> audience = ParticleTornadoEffect.this.audience.get(this.data, this.entity);
                            if (ParticleTornadoEffect.this.particleData == null) {
                                if (ParticleTornadoEffect.this.color != null) {
                                    ParticleTornadoEffect.this.particle.sendLegacyColored(audience, l, ParticleTornadoEffect.this.pSpeed.get(this.data), ParticleTornadoEffect.this.amount.get(this.data), ParticleTornadoEffect.this.xSpread.get(this.data), ParticleTornadoEffect.this.vSpread.get(this.data), ParticleTornadoEffect.this.zSpread.get(this.data), ParticleTornadoEffect.this.color);
                                } else {
                                    ParticleTornadoEffect.this.particle.send(audience, l, ParticleTornadoEffect.this.pSpeed.get(this.data), ParticleTornadoEffect.this.amount.get(this.data), ParticleTornadoEffect.this.xSpread.get(this.data), ParticleTornadoEffect.this.vSpread.get(this.data), ParticleTornadoEffect.this.zSpread.get(this.data));
                                }
                            } else {
                                ParticleTornadoEffect.this.particle.send(audience, l, ParticleTornadoEffect.this.pSpeed.get(this.data), ParticleTornadoEffect.this.amount.get(this.data), ParticleTornadoEffect.this.xSpread.get(this.data), ParticleTornadoEffect.this.vSpread.get(this.data), ParticleTornadoEffect.this.zSpread.get(this.data), ParticleTornadoEffect.this.particleData, ParticleTornadoEffect.this.exactOffsets);
                            }
                        } else {
                            new ParticleMaker.ParticlePacket(ParticleTornadoEffect.this.strParticle, ParticleTornadoEffect.this.xSpread.get(this.data), ParticleTornadoEffect.this.vSpread.get(this.data), ParticleTornadoEffect.this.zSpread.get(this.data), (float)((double)ParticleTornadoEffect.this.pSpeed.get(this.data) + (double)ParticleTornadoEffect.this.particleSpeedRamp * y), ParticleTornadoEffect.this.amount.get(this.data), true).send(l, ParticleTornadoEffect.this.viewDistance);
                        }
                        t2.subtract(v);
                    }
                }
                l.subtract(0.0, ParticleTornadoEffect.this.yOffset, 0.0);
            }
        }
    }
}

