/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ParticleEffect;
import io.lumine.mythic.utils.Schedulers;
import io.lumine.mythic.utils.tasks.Task;
import java.util.HashSet;

public class ParticleWaveEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private String strCloudParticle;
    public int particlesFront = 10;
    public int particlesBack = 10;
    public int rows = 20;
    public float lengthFront = 1.5f;
    public float lengthBack = 3.0f;
    public float depthFront = 1.0f;
    public float heightBack = 0.5f;
    public float height = 2.0f;
    public float width = 5.0f;
    private int interval;
    private int duration;
    public double distance = 0.375;

    public ParticleWaveEffect(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.ASYNC_ONLY;
        this.strParticle = mlc.getString(new String[]{"particle", "p"}, "dripWater", new String[0]);
        this.strCloudParticle = mlc.getString(new String[]{"cloudparticle", "cp"}, "cloud", new String[0]);
        this.yOffset = mlc.getPlaceholderFloat(new String[]{"yoffset", "yo"}, 0.8f, new String[0]);
        this.interval = mlc.getInteger(new String[]{"interval", "i"}, 4);
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 200);
        this.particlesFront = mlc.getInteger(new String[]{"amountfront", "af"}, 10);
        this.particlesBack = mlc.getInteger(new String[]{"amountback", "ab"}, 10);
        this.rows = mlc.getInteger(new String[]{"rows", "r"}, 20);
        this.lengthFront = mlc.getFloat(new String[]{"lengthfront", "lf"}, 1.5f);
        this.lengthBack = mlc.getFloat(new String[]{"lengthback", "lb"}, 3.0f);
        this.depthFront = mlc.getFloat(new String[]{"depthfront", "df"}, 1.0f);
        this.height = mlc.getFloat(new String[]{"height", "h"}, 2.0f);
        this.heightBack = mlc.getFloat(new String[]{"heightback", "hb"}, 0.5f);
        this.width = mlc.getFloat(new String[]{"width", "w"}, 5.0f);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        new Animator(target, this.interval, this.duration);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Animator(target, this.interval, this.duration);
        return SkillResult.SUCCESS;
    }

    private class Animator
    implements Runnable {
        private AbstractEntity entity;
        private AbstractLocation location;
        private int interval;
        private int duration;
        private int iteration;
        private Task task;
        HashSet<AbstractVector> waterCache = new HashSet();
        HashSet<AbstractVector> cloudCache = new HashSet();
        protected boolean firstStep = true;
        public AbstractVector velocity = new AbstractVector();

        public Animator(AbstractLocation location, int interval, int duration) {
            this(interval, duration);
            this.entity = null;
            this.location = location;
        }

        public Animator(AbstractEntity entity, int interval, int duration) {
            this(interval, duration);
            this.entity = entity;
        }

        protected Animator(int interval, int duration) {
            this.interval = interval;
            this.duration = duration;
            this.iteration = 0;
            this.task = Schedulers.async().runRepeating(this, 0L, (long)interval);
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Started ParticleWave effect", new Object[0]);
        }

        protected AbstractLocation getLocation() {
            if (this.entity != null) {
                return this.entity.getLocation();
            }
            return this.location.clone();
        }

        protected void setup(AbstractLocation location) {
        }

        @Override
        public void run() {
            AbstractLocation location = this.getLocation();
            if (this.firstStep) {
                this.velocity.copy(location.getDirection().setY(0).normalize().multiply(0.2));
                this.setup(location);
            }
            location.add(this.velocity);
            for (AbstractVector v : this.cloudCache) {
                location.add(v);
                location.subtract(v);
            }
            for (AbstractVector v : this.waterCache) {
                location.add(v);
                location.subtract(v);
            }
        }
    }
}

