/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Lists;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.drops.IDrop;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.droppables.CustomDrop;
import io.lumine.mythic.core.drops.droppables.ItemDrop;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.utils.Schedulers;
import io.lumine.mythic.utils.serialize.Position;
import io.lumine.mythic.utils.worldedit.Regions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;

@MythicMechanic(author="Ashijin", name="pasteSchematic", aliases={"schematicPaste", "fawePaste", "wePaste"}, premium=true, version="4.11", description="Pastes a schematic using Fawe")
public class PasteSchematicMechanic
extends SkillMechanic
implements ITargetedLocationSkill {
    private PlaceholderString schematicName;
    private boolean ignoreAir;
    private int x;
    private int y;
    private int z;
    private int rotation;
    private PlaceholderString chestDropTable;
    private PlaceholderString trapchestDropTable;

    public PasteSchematicMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        if (!MythicBukkit.isVolatile()) {
            MythicLogger.errorMechanicConfig(this, mlc, "fawePaste mechanic requires Mythic Premium");
            return;
        }
        this.schematicName = mlc.getPlaceholderString(new String[]{"schematic", "s"}, null, new String[0]);
        this.ignoreAir = !mlc.getBoolean(new String[]{"pasteair", "air", "a"}, false);
        this.x = mlc.getInteger(new String[]{"xoffset", "xo", "x"}, 0);
        this.y = mlc.getInteger(new String[]{"yoffset", "yo", "y"}, 0);
        this.z = mlc.getInteger(new String[]{"zoffset", "zo", "z"}, 0);
        this.rotation = mlc.getInteger(new String[]{"rotation", "rot", "r"}, 0);
        this.chestDropTable = mlc.getPlaceholderString(new String[]{"chestDropTable", "chests", "cdt"}, "", new String[0]);
        this.trapchestDropTable = mlc.getPlaceholderString(new String[]{"trapchestDropTable", "trapchests", "tcdt"}, "", new String[0]);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        if (!MythicBukkit.isVolatile()) {
            MythicLogger.errorMechanicConfig(this, this.config, "fawePaste mechanic requires Mythic Premium");
            return SkillResult.REQUIRES_PREMIUM;
        }
        String schematic = this.schematicName.get(data);
        File schematicFolder = new File(this.getPlugin().getDataFolder(), "Schematics");
        File schematicFile = new File(schematicFolder, schematic);
        if (!schematicFile.exists()) {
            MythicLogger.errorMechanicConfig(this, this.config, "Could not find schematic file " + schematicFile.getAbsolutePath());
            return SkillResult.INVALID_CONFIG;
        }
        Optional<Clipboard> maybeClipboard = Regions.loadSchematic(schematicFile);
        if (!maybeClipboard.isPresent()) {
            MythicLogger.errorMechanicConfig(this, this.config, "Could not load schematic");
            return SkillResult.INVALID_CONFIG;
        }
        Clipboard clipboard = maybeClipboard.get();
        Position position = target.toPosition();
        position = position.subtract(clipboard.getRegion().getWidth() / 2, clipboard.getRegion().getHeight() / 2, clipboard.getRegion().getLength() / 2);
        position = position.add(this.x, this.y, this.z);
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Pasting schematic at {0}", position.toString());
        String dropTable = this.chestDropTable.get(data);
        if (dropTable.isEmpty()) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "No chest droptables to fill", new Object[0]);
            Regions.pasteSchematic(clipboard, position, this.rotation, this.ignoreAir);
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Filling chests with droptable", new Object[0]);
            Collection<Position> chests = Regions.pasteSchematic(clipboard, position, this.rotation, this.ignoreAir, Lists.newArrayList(Material.CHEST));
            Schedulers.sync().runLater(() -> {
                for (Position pos : chests) {
                    this.fillChest(data, (Chest)pos.toLocation().getBlock().getState(), dropTable);
                }
            }, 40L);
        }
        return SkillResult.SUCCESS;
    }

    private void fillChest(SkillMetadata data, Chest chest, String dropTable) {
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "-- Filling chest ac at {0}", chest.getLocation().toString());
        chest.getInventory().clear();
        DropMetadataImpl meta = new DropMetadataImpl(data.getCaster(), data.getCaster().getEntity());
        ArrayList<ItemStack> items = Lists.newArrayList();
        ((MythicBukkit)this.getPlugin()).getDropManager().getDropTable(dropTable).get().generate(meta).getLootTable().forEach(type -> {
            IDrop drop;
            double amount = type.getAmount();
            if (type instanceof CustomDrop) {
                if (((CustomDrop)type).getDrop().isEmpty()) {
                    return;
                }
                drop = ((CustomDrop)type).getDrop().get();
            } else {
                drop = type;
            }
            if (drop instanceof ItemDrop) {
                items.add(BukkitAdapter.adapt(((ItemDrop)drop).getDrop(meta, amount)));
            }
        });
        for (ItemStack itemStack : items) {
            int slot = -1;
            do {
                slot = (int)(Math.random() * (double)chest.getInventory().getSize());
            } while (chest.getInventory().getItem(slot) != null);
            int fslot = slot;
            chest.getInventory().setItem(fslot, itemStack);
        }
    }
}

