/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.items.LegacyItemConverter;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.utils.Events;
import io.lumine.mythic.utils.Schedulers;
import io.lumine.mythic.utils.terminable.Terminable;
import io.lumine.mythic.utils.version.MinecraftVersions;
import io.lumine.mythic.utils.version.ServerVersion;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.block.BlockBreakEvent;

@MythicMechanic(author="Ashijin", name="prison", description="Traps the target entity in blocks")
public class PrisonMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderInt duration;
    protected boolean breakable;
    protected Material material = Material.AIR;
    protected byte materialData;

    public PrisonMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.duration = mlc.getPlaceholderInteger(new String[]{"duration", "d"}, 100, new String[0]);
        this.breakable = mlc.getBoolean(new String[]{"breakable", "b"}, false);
        String mat = mlc.getString(new String[]{"material", "m", "type", "t"}, "ICE", new String[0]);
        this.materialData = (byte)mlc.getInteger(new String[]{"materialdata", "md"}, 0);
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_13)) {
            try {
                this.material = this.materialData == 0 ? Material.valueOf((String)mat) : LegacyItemConverter.getMaterial(mat, this.materialData);
            }
            catch (Exception ex) {
                this.material = LegacyItemConverter.getMaterial(mat, this.materialData);
            }
        } else {
            this.material = Material.getMaterial((String)mat.toUpperCase());
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (this.material == null) {
            return SkillResult.INVALID_CONFIG;
        }
        new Prison(data, target);
        return SkillResult.SUCCESS;
    }

    private class Prison
    implements Terminable {
        private AbstractEntity prisoner;
        private AbstractLocation location;
        private ArrayList<Block> prisonBlocks = new ArrayList();
        private Terminable listener;

        public Prison(SkillMetadata data, AbstractEntity prisoner) {
            this.prisoner = prisoner;
            int x = prisoner.getLocation().getBlockX();
            int y = prisoner.getLocation().getBlockY();
            int z = prisoner.getLocation().getBlockZ();
            this.location = new AbstractLocation(prisoner.getWorld(), x < 0 ? (double)x - 0.5 : (double)x + 0.5, (double)y + 0.5, z < 0 ? (double)z - 0.5 : (double)z + 0.5, prisoner.getLocation().getYaw(), prisoner.getLocation().getPitch());
            this.listener = Events.subscribe(BlockBreakEvent.class).handler(event -> {
                if (this.prisonBlocks.contains(event.getBlock())) {
                    event.setCancelled(true);
                    if (PrisonMechanic.this.breakable) {
                        event.getBlock().setType(Material.AIR);
                    }
                }
            });
            prisoner.teleport(this.location);
            this.imprison();
            Schedulers.sync().runLater(() -> this.terminate(), PrisonMechanic.this.duration.get(data, prisoner));
        }

        private void imprison() {
            Entity target = BukkitAdapter.adapt(this.prisoner);
            Block feet = target.getLocation().getBlock();
            Block temp = feet.getRelative(1, 0, 0);
            if (temp.getType() == Material.AIR) {
                temp.setType(PrisonMechanic.this.material);
                this.prisonBlocks.add(temp);
            }
            if ((temp = feet.getRelative(1, 1, 0)).getType() == Material.AIR) {
                temp.setType(PrisonMechanic.this.material);
                this.prisonBlocks.add(temp);
            }
            if ((temp = feet.getRelative(-1, 0, 0)).getType() == Material.AIR) {
                temp.setType(PrisonMechanic.this.material);
                this.prisonBlocks.add(temp);
            }
            if ((temp = feet.getRelative(-1, 1, 0)).getType() == Material.AIR) {
                temp.setType(PrisonMechanic.this.material);
                this.prisonBlocks.add(temp);
            }
            if ((temp = feet.getRelative(0, 0, 1)).getType() == Material.AIR) {
                temp.setType(PrisonMechanic.this.material);
                this.prisonBlocks.add(temp);
            }
            if ((temp = feet.getRelative(0, 1, 1)).getType() == Material.AIR) {
                temp.setType(PrisonMechanic.this.material);
                this.prisonBlocks.add(temp);
            }
            if ((temp = feet.getRelative(0, 0, -1)).getType() == Material.AIR) {
                temp.setType(PrisonMechanic.this.material);
                this.prisonBlocks.add(temp);
            }
            if ((temp = feet.getRelative(0, 1, -1)).getType() == Material.AIR) {
                temp.setType(PrisonMechanic.this.material);
                this.prisonBlocks.add(temp);
            }
            if ((temp = feet.getRelative(0, -1, 0)).getType() == Material.AIR) {
                temp.setType(PrisonMechanic.this.material);
                this.prisonBlocks.add(temp);
            }
            if ((temp = feet.getRelative(0, 2, 0)).getType() == Material.AIR) {
                temp.setType(PrisonMechanic.this.material);
                this.prisonBlocks.add(temp);
            }
        }

        @Override
        public void close() {
            for (Block block : this.prisonBlocks) {
                if (PrisonMechanic.this.material != block.getType()) continue;
                block.setType(Material.AIR);
            }
            this.listener.closeAndReportException();
        }
    }
}

