/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.projectiles.ProjectileSurfaceMode;
import io.lumine.mythic.core.utils.BlockUtil;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.core.utils.physics.CollisionHelper;
import io.lumine.mythic.core.utils.physics.PhysicsCollision;
import io.lumine.mythic.utils.numbers.Numbers;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.BoundingBox;

@MythicMechanic(author="Ashijin", name="projectile", aliases={"p"}, description="Launches a custom projectile at the target")
public class ProjectileMechanic
extends Projectile
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected ProjectileType type;
    protected float projectileGravity;
    protected boolean bounce;
    protected float bounceVelocityMod;
    protected ProjectileSurfaceMode surfaceMode = ProjectileSurfaceMode.NONE;
    protected float heightFromSurface;

    public ProjectileMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        String type = mlc.getString("type", "NORMAL");
        this.type = ProjectileType.valueOf(type.toUpperCase());
        this.projectileGravity = mlc.getFloat(new String[]{"gravity", "g"}, 0.0f);
        this.bounce = mlc.getBoolean(new String[]{"bounces", "bounce"}, false);
        this.bounceVelocityMod = mlc.getFloat(new String[]{"bouncevelocity", "bv"}, 0.9f);
        boolean hugSurface = mlc.getBoolean(new String[]{"hugsurface", "hs"}, false);
        this.heightFromSurface = mlc.getFloat(new String[]{"heightfromsurface", "hfs"}, 0.5f);
        if (hugSurface) {
            boolean hugWater = mlc.getBoolean(new String[]{"hugliquid", "hugwater", "huglava"}, false);
            this.surfaceMode = hugWater ? ProjectileSurfaceMode.WATER : ProjectileSurfaceMode.SURFACE;
        }
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        try {
            new ProjectileMechanicTracker(data, target.clone().add(0.0, this.targetYOffset.get(data), 0.0));
            return SkillResult.SUCCESS;
        }
        catch (Exception ex) {
            MythicLogger.error("An error occurred executing a Projectile Mechanic", ex);
            return SkillResult.ERROR;
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.castAtLocation(data, target.getLocation().add(0.0, target.getEyeHeight() / 2.0, 0.0));
    }

    public ProjectileSurfaceMode getSurfaceMode() {
        return this.surfaceMode;
    }

    protected static enum ProjectileType {
        NORMAL,
        METEOR;

    }

    public class ProjectileMechanicTracker
    extends Projectile.ProjectileTracker {
        private float gravity;
        private float bounciness;
        private AbstractLocation target;
        private int currentX;
        private int currentZ;

        public ProjectileMechanicTracker(SkillMetadata data, AbstractLocation target) {
            super(ProjectileMechanic.this, data, target);
            this.gravity = 0.0f;
            this.bounciness = 0.0f;
            this.target = target;
            if (ProjectileMechanic.this.bounce) {
                this.bounciness = ProjectileMechanic.this.projectileVelocity.get(data);
            }
            this.start();
        }

        @Override
        public void projectileStart() {
            float velocity;
            if (ProjectileMechanic.this.type == ProjectileType.METEOR) {
                this.startLocation = this.target.clone();
                this.startLocation.add(0.0, ProjectileMechanic.this.heightFromSurface, 0.0);
                if (ProjectileMechanic.this.projectileGravity <= 0.0f) {
                    this.gravity = ProjectileMechanic.this.projectileVelocity.get(this.data);
                    this.gravity = this.gravity > 0.0f ? this.gravity / ProjectileMechanic.this.ticksPerSecond : 0.0f;
                } else {
                    this.gravity = ProjectileMechanic.this.projectileGravity > 0.0f ? ProjectileMechanic.this.projectileGravity / ProjectileMechanic.this.ticksPerSecond : 0.0f;
                }
                velocity = 0.0f;
            } else {
                double eso;
                double sso;
                double sfo;
                this.startLocation = ProjectileMechanic.this.sourceIsOrigin ? this.data.getOrigin().clone() : this.data.getCaster().getEntity().getLocation().clone();
                velocity = ProjectileMechanic.this.projectileVelocity.get(this.data) / ProjectileMechanic.this.ticksPerSecond;
                this.gravity = ProjectileMechanic.this.projectileGravity > 0.0f ? ProjectileMechanic.this.projectileGravity / ProjectileMechanic.this.ticksPerSecond : 0.0f;
                double syo = ProjectileMechanic.this.startYOffset.get(this.data);
                if (syo != 0.0) {
                    this.startLocation.setY(this.startLocation.getY() + syo);
                }
                if ((sfo = (double)(ProjectileMechanic.this.startForwardOffset.get(this.data) * -1.0f)) != 0.0) {
                    this.startLocation = MythicUtil.move(this.startLocation, sfo, 0.0, 0.0);
                }
                if ((sso = ProjectileMechanic.this.startSideOffset.get(this.data)) != 0.0) {
                    this.startLocation = MythicUtil.move(this.startLocation, 0.0, 0.0, sso);
                }
                if ((eso = ProjectileMechanic.this.endSideOffset.get(this.data)) != 0.0) {
                    this.target.setDirection(this.startLocation.getDirection());
                    this.target = MythicUtil.move(this.target, 0.0, 0.0, eso);
                }
            }
            this.previousLocation = this.startLocation.clone();
            this.currentLocation = this.startLocation.clone();
            if (this.currentLocation == null) {
                return;
            }
            this.currentVelocity = this.target.toVector().rotate(0.001f).subtract(this.currentLocation.toVector()).normalize();
            if (ProjectileMechanic.this.projectileVelocityHorizOffset.get(this.data) != 0.0f || ProjectileMechanic.this.projectileVelocityHorizNoise > 0.0f) {
                float noise = 0.0f;
                if (ProjectileMechanic.this.projectileVelocityHorizNoise > 0.0f) {
                    noise = (float)((double)ProjectileMechanic.this.projectileVelocityHorizNoiseBase + Numbers.randomDouble() * (double)ProjectileMechanic.this.projectileVelocityHorizNoise);
                }
                this.currentVelocity.rotate(ProjectileMechanic.this.projectileVelocityHorizOffset.get(this.data) + noise);
            }
            if (ProjectileMechanic.this.projectileVelocityVertOffset.get(this.data) != 0.0f || ProjectileMechanic.this.projectileVelocityVertNoise > 0.0f) {
                float noise = 0.0f;
                if (ProjectileMechanic.this.projectileVelocityVertNoise > 0.0f) {
                    noise = (float)((double)ProjectileMechanic.this.projectileVelocityVertNoiseBase + Numbers.randomDouble() * (double)ProjectileMechanic.this.projectileVelocityVertNoise);
                }
                this.currentVelocity.add(new AbstractVector(0.0f, ProjectileMechanic.this.projectileVelocityVertOffset.get(this.data) + noise, 0.0f)).normalize();
            }
            if (ProjectileMechanic.this.surfaceMode != ProjectileSurfaceMode.NONE) {
                this.currentLocation.setY((float)((int)this.currentLocation.getY()) + ProjectileMechanic.this.heightFromSurface);
                this.currentVelocity.setY(0).normalize();
            }
            if (ProjectileMechanic.this.powerAffectsVelocity) {
                this.currentVelocity.multiply(this.power);
            }
            this.currentVelocity.multiply(velocity);
            if (ProjectileMechanic.this.projectileGravity > 0.0f) {
                this.currentVelocity.setY(this.currentVelocity.getY() - (double)this.gravity);
            }
        }

        public void setVelocity(double value) {
            this.currentVelocity = this.currentVelocity.normalize().multiply(value);
        }

        public void modifyVelocity(double v) {
            this.currentVelocity = this.currentVelocity.multiply(v);
        }

        public void setGravity(float p) {
            this.gravity = p;
        }

        public void modifyGravity(float p) {
            this.gravity *= p;
        }

        @Override
        public void projectileTick() {
            this.previousLocation = this.currentLocation.clone();
            this.currentLocation.add(this.currentVelocity);
            if (ProjectileMechanic.this.surfaceMode != ProjectileSurfaceMode.NONE) {
                if (this.currentLocation.getBlockX() != this.currentX || this.currentLocation.getBlockZ() != this.currentZ) {
                    Block b = BukkitAdapter.adapt(this.currentLocation.subtract(0.0, ProjectileMechanic.this.heightFromSurface, 0.0)).getBlock();
                    if (BlockUtil.isPathable(b, this, ProjectileMechanic.this.surfaceMode)) {
                        attempts = 0;
                        ok = false;
                        while (attempts++ < 10) {
                            if (BlockUtil.isPathable(b = b.getRelative(BlockFace.DOWN), this, ProjectileMechanic.this.surfaceMode)) {
                                this.currentLocation.add(0.0, -1.0, 0.0);
                                continue;
                            }
                            ok = true;
                            break;
                        }
                        if (!ok) {
                            this.terminate();
                            return;
                        }
                    } else {
                        attempts = 0;
                        ok = false;
                        while (attempts++ < 10) {
                            b = b.getRelative(BlockFace.UP);
                            this.currentLocation.add(0.0, 1.0, 0.0);
                            if (!BlockUtil.isPathable(b)) continue;
                            ok = true;
                            break;
                        }
                        if (!ok) {
                            this.terminate();
                            return;
                        }
                    }
                    this.currentLocation.setY((float)((int)this.currentLocation.getY()) + ProjectileMechanic.this.heightFromSurface);
                    this.currentX = this.currentLocation.getBlockX();
                    this.currentZ = this.currentLocation.getBlockZ();
                }
            } else if (ProjectileMechanic.this.projectileGravity != 0.0f) {
                this.currentVelocity.setY(this.currentVelocity.getY() - (double)(ProjectileMechanic.this.projectileGravity / ProjectileMechanic.this.ticksPerSecond));
            }
            if (ProjectileMechanic.this.bounce && MythicBukkit.isVolatile()) {
                this.handleBounce();
            } else if (ProjectileMechanic.this.stopOnHitGround && !BlockUtil.isPathable(BukkitAdapter.adapt(this.currentLocation).getBlock(), this)) {
                this.currentLocation = this.previousLocation;
                this.terminate();
                return;
            }
            if (this.bullet != null) {
                this.applyBulletVelocity();
            }
            if (ProjectileMechanic.this.onTickSkill.isPresent() && ((Skill)ProjectileMechanic.this.onTickSkill.get()).isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                AbstractLocation location = ProjectileMechanic.this.bulletType == Projectile.BulletType.ARROW ? this.previousLocation.clone() : this.currentLocation.clone();
                HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
                targets.add(location);
                sData.setLocationTargets(targets);
                sData.setOrigin(location);
                ((Skill)ProjectileMechanic.this.onTickSkill.get()).execute(sData);
            }
            this.evaluateTargetsInBB();
            if (!this.targets.isEmpty()) {
                this.doHit((Collection)this.targets.clone());
                if (ProjectileMechanic.this.stopOnHitEntity) {
                    this.terminate();
                }
            }
            this.targets.clear();
        }

        @Override
        public void applyBulletVelocity() {
            if (ProjectileMechanic.this.bulletType == Projectile.BulletType.TRACKING) {
                this.orientBulletArmorStand();
            } else if (ProjectileMechanic.this.bulletType == Projectile.BulletType.ITEM) {
                AbstractLocation ol = this.previousLocation.clone().subtract(0.0, 0.35, 0.0);
                ((MythicBukkit)ProjectileMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setItemPosition(this.bullet, ol);
                this.bullet.setVelocity(this.currentLocation.toVector().subtract(this.previousLocation.toVector()));
            } else if (ProjectileMechanic.this.bulletType == Projectile.BulletType.ARROW) {
                this.bullet.setVelocity(this.currentLocation.toVector().subtract(this.bullet.getLocation().clone().toVector()).multiply(0.25));
            } else if (ProjectileMechanic.this.bulletType == Projectile.BulletType.MOB) {
                AbstractLocation ol = this.currentLocation.clone().add(this.currentVelocity).subtract(0.0, 1.35, 0.0);
                if (ProjectileMechanic.this.bulletSpin != 0.0f) {
                    float newSpin = this.bullet.getLocation().getYaw() + ProjectileMechanic.this.bulletSpin;
                    ol.setYaw(newSpin);
                } else if (ProjectileMechanic.this.bulletMatchDirection) {
                    ol.setDirection(this.currentVelocity);
                }
                this.bullet.teleport(ol);
            } else {
                this.bullet.setVelocity(this.currentLocation.toVector().subtract(this.bullet.getLocation().clone().toVector()).multiply(1));
                if (ProjectileMechanic.this.bulletSpin > 0.0f) {
                    float newSpin = this.bullet.getLocation().getYaw() + ProjectileMechanic.this.bulletSpin;
                    ((MythicBukkit)ProjectileMechanic.this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setEntityRotation(this.bullet, newSpin, newSpin);
                }
            }
        }

        private void doHit(Collection<AbstractEntity> targets) {
            if (ProjectileMechanic.this.onHitSkill.isPresent()) {
                SkillMetadata sData = this.data.deepClone();
                sData.setEntityTargets(targets);
                sData.setOrigin(this.currentLocation.clone());
                if (((Skill)ProjectileMechanic.this.onHitSkill.get()).isUsable(sData)) {
                    ((Skill)ProjectileMechanic.this.onHitSkill.get()).execute(sData);
                }
            }
        }

        @Override
        public void setCancelled() {
            this.terminate();
        }

        @Override
        public boolean getCancelled() {
            return this.components.hasTerminated();
        }

        public boolean handleBounce() {
            this.executeProjectileSkill(ProjectileMechanic.this.onBounceSkill, this.data, false);
            BoundingBox bb = BoundingBox.of((Location)BukkitAdapter.adapt(this.currentLocation), (double)ProjectileMechanic.this.hitRadius, (double)ProjectileMechanic.this.verticalHitRadius, (double)ProjectileMechanic.this.hitRadius);
            BlockFace collided = null;
            double bV = 0.0;
            for (PhysicsCollision collision : CollisionHelper.getCollisions(this.currentVelocity, bb, this.previousLocation)) {
                switch (collision.getBlockFace()) {
                    case NORTH: {
                        double magnitude = Math.abs(this.currentVelocity.getZ());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.NORTH;
                        break;
                    }
                    case EAST: {
                        double magnitude = Math.abs(this.currentVelocity.getZ());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.EAST;
                        break;
                    }
                    case SOUTH: {
                        double magnitude = Math.abs(this.currentVelocity.getZ());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.SOUTH;
                        break;
                    }
                    case WEST: {
                        double magnitude = Math.abs(this.currentVelocity.getZ());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.WEST;
                        break;
                    }
                    case UP: {
                        double magnitude = Math.abs(this.currentVelocity.getY());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.UP;
                        break;
                    }
                    case DOWN: {
                        double magnitude = Math.abs(this.currentVelocity.getY());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.DOWN;
                        break;
                    }
                }
            }
            if (collided == null) {
                return false;
            }
            switch (collided) {
                case NORTH: {
                    if (!(this.currentVelocity.getZ() > 0.0)) break;
                    this.currentVelocity.setZ(this.currentVelocity.getZ() * -0.995);
                    break;
                }
                case EAST: {
                    if (!(this.currentVelocity.getX() < 0.0)) break;
                    this.currentVelocity.setX(this.currentVelocity.getX() * -0.995);
                    break;
                }
                case SOUTH: {
                    if (!(this.currentVelocity.getZ() < 0.0)) break;
                    this.currentVelocity.setZ(this.currentVelocity.getZ() * -0.995);
                    break;
                }
                case WEST: {
                    if (!(this.currentVelocity.getX() > 0.0)) break;
                    this.currentVelocity.setX(this.currentVelocity.getX() * -0.995);
                    break;
                }
                case UP: {
                    if (!(this.currentVelocity.getY() < 0.0)) break;
                    if (this.currentVelocity.getY() <= (double)(this.gravity * -1.0f)) {
                        this.currentVelocity.setY(this.currentVelocity.getY() * -0.8);
                        break;
                    }
                    this.currentVelocity.setY(0);
                    return true;
                }
                case DOWN: {
                    if (!(this.currentVelocity.getY() > 0.0)) break;
                    this.currentVelocity.setY(this.currentVelocity.getY() * -0.95);
                }
            }
            this.currentVelocity.multiply(ProjectileMechanic.this.bounceVelocityMod);
            return false;
        }
    }
}

