/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.util.HashSet;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

@MythicMechanic(author="Ashijin", name="rally", aliases={"callforhelp"}, description="Calls for nearby entities to attack the target")
public class RallyMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected double hRadius;
    protected double vRadius;
    protected boolean overwriteTarget;
    HashSet<MythicMob> mmTypes = new HashSet();
    HashSet<BukkitEntityType> meTypes = new HashSet();

    public RallyMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.hRadius = mlc.getDouble("radius", 10.0);
        this.vRadius = mlc.getDouble("radius", 10.0);
        this.hRadius = mlc.getDouble("r", this.hRadius);
        this.vRadius = mlc.getDouble("r", this.vRadius);
        this.hRadius = mlc.getDouble("hradius", this.hRadius);
        this.vRadius = mlc.getDouble("vradius", this.vRadius);
        this.overwriteTarget = mlc.getBoolean(new String[]{"overwritetarget, ot"}, true);
        String typeString = mlc.getString(new String[]{"types", "type", "t"}, "", new String[0]);
        String[] types = typeString.split(",");
        RallyMechanic THIS = this;
        ((MythicBukkit)this.getPlugin()).getSkillManager().queueSecondPass(() -> {
            for (String s2 : types) {
                MythicMob mm4 = MythicBukkit.inst().getMobManager().getMythicMob(s2).orElseGet(() -> null);
                if (mm4 != null) {
                    THIS.mmTypes.add(mm4);
                    continue;
                }
                BukkitEntityType me = BukkitEntityType.getMythicEntity(s2);
                if (me != null) {
                    THIS.meTypes.add(me);
                    continue;
                }
                MythicLogger.errorMechanicConfig(this, mlc, "The 'type' attribute must be a valid MythicMob or MythicEntity type.");
            }
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        List moblist = data.getCaster().getEntity().getBukkitEntity().getNearbyEntities(this.hRadius, this.vRadius, this.hRadius);
        block0: for (Entity e : moblist) {
            if (!(e instanceof LivingEntity)) continue;
            ActiveMob amx = MythicBukkit.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt(e));
            if (amx != null && this.mmTypes.contains(amx.getType())) {
                if (!this.overwriteTarget && amx.hasTarget()) continue;
                amx.setTarget(target);
                continue;
            }
            for (BukkitEntityType me : this.meTypes) {
                if (!me.compare(e)) continue;
                MythicBukkit.inst().getVolatileCodeHandler().getAIHandler().setTarget((LivingEntity)e, (LivingEntity)BukkitAdapter.adapt(target));
                continue block0;
            }
        }
        return SkillResult.SUCCESS;
    }
}

