/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderStringImpl;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.utils.numbers.Numbers;
import java.util.ArrayList;
import java.util.List;

@MythicMechanic(author="Ashijin", name="randommessage", aliases={"randommsg", "rmsg", "rm"}, description="Sends a random message to the target player")
public class RandomMessageMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected List<PlaceholderString> messages = new ArrayList<PlaceholderString>();

    public RandomMessageMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.target_creative = true;
        try {
            String m4 = mlc.getString(new String[]{"messages", "message", "msg", "msgs", "m"});
            for (String s2 : m4.split(",")) {
                s2 = s2.trim();
                this.messages.add(new PlaceholderStringImpl(s2));
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Loaded RandomMessage " + s2.substring(1, s2.length() - 1), new Object[0]);
            }
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "The 'messages' attribute is required.");
            this.messages.add(new PlaceholderStringImpl("INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD."));
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        PlaceholderString message = this.messages.get(Numbers.randomInt(this.messages.size()));
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Executing RandomMessage skill with message: " + message, new Object[0]);
        if (target.isPlayer()) {
            target.asPlayer().sendMessage(message.get(data, target));
            return SkillResult.SUCCESS;
        }
        return SkillResult.INVALID_TARGET;
    }
}

