/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="remount", description="Causes the caster to remount their mount")
public class RemountMechanic
extends SkillMechanic
implements INoTargetSkill {
    public RemountMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        SkillCaster caster = data.getCaster();
        if (!(caster instanceof ActiveMob)) {
            return SkillResult.INVALID_TARGET;
        }
        ActiveMob am = (ActiveMob)caster;
        if (data.getCaster().getEntity().getVehicle() == null && am.getMount().isPresent() && !am.getMount().get().isDead()) {
            AbstractEntity entity = am.getEntity();
            AbstractEntity mount = am.getMount().get().getEntity();
            mount.setPassenger(entity);
        }
        return SkillResult.SUCCESS;
    }
}

