/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitBlock;
import io.lumine.mythic.core.items.LegacyItemConverter;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.utils.numbers.Numbers;
import io.lumine.mythic.utils.version.MinecraftVersions;
import io.lumine.mythic.utils.version.ServerVersion;
import org.bukkit.Axis;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;

public class SetBlockTypeMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    private String strMaterial;
    private AbstractBlock block;
    private PlaceholderInt age;
    private BlockFace blockFace;
    private Axis axis;
    private Bisected.Half bisectedHalf;
    private boolean waterLogged;
    private Slab.Type slabType;
    private FaceAttachable.AttachedFace faceAttach;
    private Stairs.Shape stairShape;

    public SetBlockTypeMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        Material material;
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.age = mlc.getPlaceholderInteger(new String[]{"age", "a"}, 0, new String[0]);
        this.waterLogged = mlc.getBoolean(new String[]{"waterlogged", "wlogged"}, false);
        String blockFace = mlc.getString(new String[]{"blockface", "bf"}, "NORTH", new String[0]).toUpperCase();
        String axis = mlc.getString(new String[]{"axis"}, "Y", new String[0]).toUpperCase();
        String bisectedHalf = mlc.getString(new String[]{"bisectedhalf", "bhalf"}, "TOP", new String[0]).toUpperCase();
        String slabType = mlc.getString(new String[]{"slabtype", "sb"}, "BOTTOM", new String[0]).toUpperCase();
        String faceAttach = mlc.getString(new String[]{"attachedFace", "af"}, "WALL", new String[0]).toUpperCase();
        String stairShape = mlc.getString(new String[]{"stairshape", "shape"}, "STRAIGHT", new String[0]).toUpperCase();
        try {
            this.blockFace = BlockFace.valueOf((String)blockFace);
        }
        catch (Exception ex) {
            this.blockFace = BlockFace.UP;
        }
        try {
            this.axis = Axis.valueOf((String)axis);
        }
        catch (Exception ex) {
            this.axis = Axis.Y;
        }
        try {
            this.bisectedHalf = Bisected.Half.valueOf((String)bisectedHalf);
        }
        catch (Exception ex) {
            this.bisectedHalf = Bisected.Half.TOP;
        }
        try {
            this.slabType = Slab.Type.valueOf((String)slabType);
        }
        catch (Exception ex) {
            this.slabType = Slab.Type.BOTTOM;
        }
        try {
            this.faceAttach = FaceAttachable.AttachedFace.valueOf((String)faceAttach);
        }
        catch (Exception ex) {
            this.faceAttach = FaceAttachable.AttachedFace.FLOOR;
        }
        try {
            this.stairShape = Stairs.Shape.valueOf((String)stairShape);
        }
        catch (Exception ex) {
            this.stairShape = Stairs.Shape.STRAIGHT;
        }
        this.strMaterial = mlc.getString(new String[]{"material", "mat", "m", "type", "t"}, "DIRT", new String[0]).toUpperCase();
        byte materialData = (byte)mlc.getInteger(new String[]{"materialdata", "md", "data", "dv"}, 0);
        if (this.strMaterial.startsWith("MMOITEMS:")) {
            ((MythicBukkit)this.getPlugin()).getCompatibility().getMMOItems().ifPresent(mmoItems -> Numbers.parseIntegerOpt(this.strMaterial.substring(9)).ifPresent(id -> {
                this.block = mmoItems.getMMOItemsBlock((int)id);
            }));
            return;
        }
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_15)) {
            try {
                material = materialData == 0 ? Material.valueOf((String)this.strMaterial) : LegacyItemConverter.getMaterial(this.strMaterial, materialData);
            }
            catch (Exception ex) {
                material = LegacyItemConverter.getMaterial(this.strMaterial, materialData);
            }
        } else {
            try {
                material = Material.valueOf((String)this.strMaterial);
            }
            catch (Exception ex) {
                MythicLogger.errorMechanicConfig(this, mlc, "'Material' must be a valid Material type.");
                material = Material.GRAVEL;
            }
        }
        this.block = new BukkitBlock(material);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.setBlock(data, target.getLocation(), this.age.get(data, target));
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.setBlock(data, target, this.age.get(data));
        return SkillResult.SUCCESS;
    }

    protected void setBlock(SkillMetadata data, AbstractLocation target, int age) {
        if (this.strMaterial.startsWith("MMOITEMS:")) {
            this.block.set(target);
        } else {
            this.block.set(target, age, this.bisectedHalf, this.blockFace, this.axis, this.slabType, this.waterLogged, this.faceAttach, this.stairShape);
        }
    }
}

