/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.utils.version.MinecraftVersions;
import io.lumine.mythic.utils.version.ServerVersion;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;

public class SetOwnerMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    public SetOwnerMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (data.getCaster() instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)data.getCaster();
            double maxHealth = am.getEntity().getMaxHealth();
            double currentHealth = am.getEntity().getHealth();
            am.setOwner(target.getUniqueId());
            if (target.isPlayer()) {
                Entity entity = data.getCaster().getEntity().getBukkitEntity();
                if (entity instanceof Wolf) {
                    ((Wolf)entity).setOwner((AnimalTamer)((Player)target.getBukkitEntity()));
                    ((Wolf)entity).setTamed(true);
                } else if (entity instanceof Parrot) {
                    ((Parrot)entity).setOwner((AnimalTamer)((Player)target.getBukkitEntity()));
                    ((Parrot)entity).setTamed(true);
                } else if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14) && entity instanceof Cat) {
                    ((Cat)entity).setOwner((AnimalTamer)((Player)target.getBukkitEntity()));
                    ((Cat)entity).setTamed(true);
                }
            }
            am.getEntity().setMaxHealth(maxHealth);
            am.getEntity().setHealth(currentHealth);
            return SkillResult.SUCCESS;
        }
        return SkillResult.SUCCESS;
    }
}

