/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.SkillAdapter;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="shootfireball", aliases={"fireball"}, description="Shoots a projectile at the target location")
public class ShootFireballMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected FireballType type;
    protected float yield;
    protected float velocity;
    protected int fireticks;
    protected boolean incendiary;
    protected boolean playsound;
    protected boolean charged = false;
    protected BukkitItemStack itemType = null;

    public ShootFireballMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.yield = mlc.getFloat(new String[]{"yield", "strength", "y", "s"}, 1.0f);
        this.velocity = mlc.getFloat(new String[]{"velocity", "v"}, 1.0f);
        this.fireticks = mlc.getInteger(new String[]{"fireticks", "ft"}, 0);
        this.incendiary = mlc.getBoolean(new String[]{"incendiary", "i"}, false);
        this.playsound = mlc.getBoolean(new String[]{"playsound", "ps"}, false);
        this.charged = mlc.getBoolean(new String[]{"charged", "c"}, false);
        String strItem = mlc.getString(new String[]{"item", "material"}, "BLAZE_POWDER", new String[0]);
        this.itemType = new BukkitItemStack(strItem);
        FireballType def = FireballType.NORMAL;
        if (mlc.getBoolean(new String[]{"smallfireball", "small", "sml"}, false)) {
            def = FireballType.SMALL;
        }
        String strType = mlc.getString(new String[]{"type", "t"}, def.toString(), new String[0]);
        try {
            this.type = FireballType.valueOf(strType.toUpperCase());
        }
        catch (Error | Exception ex) {
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid Fireball type supplied");
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.castAtLocation(data, target.getLocation());
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        SkillAdapter.get().shootFireball(data.getCaster(), this.type, target, this.velocity, this.yield, this.incendiary, this.fireticks, this.playsound, this.charged, this.itemType);
        return SkillResult.SUCCESS;
    }

    public static enum FireballType {
        NORMAL,
        SMALL,
        LARGE,
        WITHER,
        DRAGON,
        ITEM;

    }
}

