/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.PotionMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.utils.version.MinecraftVersions;
import io.lumine.mythic.utils.version.ServerVersion;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

@MythicMechanic(author="Ashijin", name="shootpotion", description="Shoots a splash potion")
public class ShootPotionMechanic
extends PotionMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected float velocity;

    public ShootPotionMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.velocity = mlc.getFloat(new String[]{"velocity", "v"}, 1.0f);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.castAtLocation(data, target.getLocation());
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        PotionEffect effect;
        String potionEffect = this.effect.get(data);
        int duration = this.duration.get(data);
        int lvl = this.lvl.get(data);
        try {
            effect = ServerVersion.isAfterOrEq(MinecraftVersions.v1_15) ? new PotionEffect(PotionEffectType.getByName((String)potionEffect), duration, lvl, this.hasParticles, this.hasIcon) : new PotionEffect(PotionEffectType.getByName((String)potionEffect), duration, lvl);
        }
        catch (Exception ex) {
            MythicLogger.errorMechanicConfig(this, this.config, "The 'type' attribute must be a valid potion type.");
            return SkillResult.INVALID_CONFIG;
        }
        ItemStack potion = new ItemStack(Material.SPLASH_POTION);
        PotionMeta pm = (PotionMeta)potion.getItemMeta();
        pm.addCustomEffect(effect, true);
        potion.setItemMeta((ItemMeta)pm);
        LivingEntity bukkitShooter = (LivingEntity)data.getCaster().getEntity().getBukkitEntity();
        Projectile projectile = bukkitShooter.launchProjectile(ThrownPotion.class);
        ((ThrownPotion)projectile).setItem(potion);
        projectile.setVelocity(bukkitShooter.getLocation().getDirection().multiply(this.velocity));
        projectile.setBounce(false);
        projectile.setShooter((ProjectileSource)bukkitShooter);
        return SkillResult.SUCCESS;
    }
}

