/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;

public class SummonPassengerMechanic
extends SkillMechanic
implements INoTargetSkill {
    protected MythicMob mount;
    protected String strType;

    public SummonPassengerMechanic(SkillExecutor manager, String skill, MythicLineConfig mlc) {
        super(manager, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.strType = mlc.getString(new String[]{"passenger", "p", "rider", "r", "type", "t"});
        this.mount = MythicBukkit.inst().getMobManager().getMythicMob(this.strType).orElseGet(() -> null);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        AbstractEntity me;
        if (this.mount == null) {
            this.mount = MythicBukkit.inst().getMobManager().getMythicMob(this.strType).orElseGet(() -> null);
            if (this.mount == null) {
                MythicLogger.errorMechanicConfig(this, this.config, "The 'mob' attribute must be a valid MythicMob.");
                return SkillResult.INVALID_CONFIG;
            }
        }
        if ((me = this.mount.spawn(data.getCaster().getEntity().getLocation(), data.getCaster().getLevel(), SpawnReason.SUMMON).getEntity()) == null) {
            return SkillResult.INVALID_CONFIG;
        }
        data.getCaster().getEntity().setPassenger(me);
        MythicBukkit.inst().getMobManager().getActiveMob(me.getUniqueId()).get().setOwner(data.getCaster().getEntity().getUniqueId());
        return SkillResult.SUCCESS;
    }
}

