/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="teleport", aliases={"tp"}, description="Teleports to the target location")
public class TeleportMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected double spreadH;
    protected double spreadV;

    public TeleportMechanic(SkillExecutor manager, String line, MythicLineConfig mlc) {
        super(manager, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.spreadH = mlc.getDouble(new String[]{"spreadh", "sh"}, 0.0);
        this.spreadV = mlc.getDouble(new String[]{"spreadv", "sv"}, 0.0);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (data.getCaster() instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)data.getCaster();
            AbstractEntity abstractEntity = am.getEntity();
            ((MythicBukkit)this.getPlugin()).getMobManager();
            abstractEntity.teleport(MobExecutor.findSafeSpawnLocation(target.getLocation(), (int)this.spreadH, (int)this.spreadV, am.getType().getMythicEntity().getHeight() + 1));
        } else {
            AbstractEntity abstractEntity = data.getCaster().getEntity();
            ((MythicBukkit)this.getPlugin()).getMobManager();
            abstractEntity.teleport(MobExecutor.findSafeSpawnLocation(target.getLocation(), (int)this.spreadH, (int)this.spreadV, 2));
        }
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        if (this.spreadH > 0.0 || this.spreadV > 0.0) {
            if (data.getCaster() instanceof ActiveMob) {
                ActiveMob am = (ActiveMob)data.getCaster();
                ((MythicBukkit)this.getPlugin()).getMobManager();
                target = MobExecutor.findSafeSpawnLocation(target, (int)this.spreadH, (int)this.spreadV, am.getType().getMythicEntity().getHeight() + 1);
            } else {
                ((MythicBukkit)this.getPlugin()).getMobManager();
                target = MobExecutor.findSafeSpawnLocation(target, (int)this.spreadH, (int)this.spreadV, 2);
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Teleporting to {0}", target.toString());
        data.getCaster().getEntity().teleport(target);
        return SkillResult.SUCCESS;
    }
}

