/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.skills.placeholders.Placeholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.types.EntityPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.GeneralPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.LocationPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.MetaPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.SpawnerPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.TargetPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.WorldPlaceholder;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;

public class PlaceholderParser {
    protected String strValue;
    protected String strUnparsedValue;
    protected boolean papi;
    private Map<String, PlaceholderExecutor.PlaceholderEntry> variables;
    protected boolean doMath = false;

    public PlaceholderParser(String string) {
        if (string == null) {
            this.strValue = null;
            this.strUnparsedValue = null;
            this.variables = null;
            this.papi = false;
            return;
        }
        try {
            if (string.startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
        }
        catch (Exception ex) {
            MythicLogger.error("Message '" + string + "' is incorrectly configured.");
            string = "INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.";
        }
        try {
            if (string.startsWith("'") && string.endsWith("'")) {
                string = string.substring(1, string.length() - 1);
            }
        }
        catch (Exception ex) {
            MythicLogger.error("Message '" + string + "' is incorrectly configured.");
            string = "INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.";
        }
        this.strUnparsedValue = SkillString.convertLegacyVariables(string);
        this.strValue = SkillString.parseMessageSpecialChars(this.strUnparsedValue);
        if (this.strValue.startsWith("eval ")) {
            this.doMath = true;
            string = string.substring(5);
        } else if (this.strValue.contains("+") || this.strValue.contains("-") || this.strValue.contains("*") || this.strValue.contains("/") || this.strValue.contains("^")) {
            this.doMath = true;
        }
        this.papi = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().isPresent() && this.strUnparsedValue.contains("%");
        this.getPlaceholderManager().registerParser(this);
        this.checkForVariables();
    }

    public void checkForVariables() {
        if (this.getPlaceholderManager().checkForVariables(this.strValue)) {
            this.variables = new HashMap<String, PlaceholderExecutor.PlaceholderEntry>();
            Matcher matcher = this.getPlaceholderManager().matcher(this.strUnparsedValue);
            while (matcher.find()) {
                String var = matcher.group(1).substring(1, matcher.group(1).length() - 1);
                PlaceholderExecutor.PlaceholderEntry transformer = this.getPlaceholderManager().getPlaceholder(var);
                if (transformer == null) continue;
                this.variables.put(var, transformer);
            }
        } else {
            this.variables = null;
        }
    }

    protected String parse(PlaceholderMeta data, AbstractEntity target) {
        if (this.variables == null || this.variables.size() == 0) {
            return this.strValue;
        }
        String string = this.strValue;
        for (Map.Entry<String, PlaceholderExecutor.PlaceholderEntry> entry : this.variables.entrySet()) {
            String key = "<" + entry.getKey() + ">";
            Placeholder pl = entry.getValue().getPlaceholder();
            String arg = entry.getValue().getArg();
            try {
                if (pl instanceof GeneralPlaceholder) {
                    string = string.replace(key, ((GeneralPlaceholder)pl).apply(arg));
                    continue;
                }
                if (pl instanceof MetaPlaceholder) {
                    string = string.replace(key, ((MetaPlaceholder)pl).apply(data, arg));
                    continue;
                }
                if (pl instanceof EntityPlaceholder) {
                    string = string.replace(key, ((EntityPlaceholder)pl).apply(target, arg));
                    continue;
                }
                if (pl instanceof TargetPlaceholder) {
                    string = string.replace(key, ((TargetPlaceholder)pl).apply(data, target, arg));
                    continue;
                }
                if (!(pl instanceof WorldPlaceholder)) continue;
                string = string.replace(key, ((WorldPlaceholder)pl).apply(target.getWorld(), arg));
            }
            catch (NullPointerException ex) {
                MythicLogger.error("Failed to process placeholder " + key + " in xPlaceholderString{'" + string + "'}", ex);
            }
        }
        return string;
    }

    protected String parse(PlaceholderMeta data, AbstractLocation target) {
        if (this.variables == null || this.variables.size() == 0) {
            return this.strValue;
        }
        String string = this.strValue;
        for (Map.Entry<String, PlaceholderExecutor.PlaceholderEntry> entry : this.variables.entrySet()) {
            String key = "<" + entry.getKey() + ">";
            Placeholder pl = entry.getValue().getPlaceholder();
            String arg = entry.getValue().getArg();
            try {
                if (pl instanceof GeneralPlaceholder) {
                    string = string.replace(key, ((GeneralPlaceholder)pl).apply(arg));
                    continue;
                }
                if (pl instanceof MetaPlaceholder) {
                    string = string.replace(key, ((MetaPlaceholder)pl).apply(data, arg));
                    continue;
                }
                if (pl instanceof LocationPlaceholder) {
                    string = string.replace(key, ((LocationPlaceholder)pl).apply(target, arg));
                    continue;
                }
                if (!(pl instanceof WorldPlaceholder)) continue;
                string = string.replace(key, ((WorldPlaceholder)pl).apply(target.getWorld(), arg));
            }
            catch (NullPointerException ex) {
                MythicLogger.error("Failed to process placeholder " + key + " in xPlaceholderString{'" + string + "'}", ex);
            }
        }
        return string;
    }

    protected String parse(MythicSpawner spawner) {
        if (this.variables == null || this.variables.size() == 0) {
            return this.strValue;
        }
        String string = this.strValue;
        for (Map.Entry<String, PlaceholderExecutor.PlaceholderEntry> entry : this.variables.entrySet()) {
            String key = "<" + entry.getKey() + ">";
            Placeholder pl = entry.getValue().getPlaceholder();
            String arg = entry.getValue().getArg();
            try {
                if (pl instanceof GeneralPlaceholder) {
                    string = string.replace(key, ((GeneralPlaceholder)pl).apply(arg));
                    continue;
                }
                if (pl instanceof SpawnerPlaceholder) {
                    string = string.replace(key, ((SpawnerPlaceholder)pl).apply(spawner, arg));
                    continue;
                }
                if (!(pl instanceof WorldPlaceholder)) continue;
                string = string.replace(key, ((WorldPlaceholder)pl).apply(spawner.getLocation().getWorld(), arg));
            }
            catch (NullPointerException ex) {
                MythicLogger.error("Failed to process placeholder " + key + " in xPlaceholderString{'" + string + "'}", ex);
            }
        }
        return string;
    }

    public boolean isStatic() {
        return this.variables == null && !this.doMath && !this.papi;
    }

    public boolean isPresent() {
        return this.strValue != null;
    }

    protected PlaceholderExecutor getPlaceholderManager() {
        return MythicBukkit.inst().getPlaceholderManager();
    }

    public String serialize() {
        return this.strUnparsedValue;
    }

    public boolean isDoMath() {
        return this.doMath;
    }

    public void setDoMath(boolean doMath) {
        this.doMath = doMath;
    }
}

