/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.parsers;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.placeholders.GenericPlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.PlaceholderParser;
import io.lumine.mythic.core.skills.placeholders.parsers.RandomDouble;
import io.lumine.mythic.core.skills.placeholders.parsers.StaticDouble;
import io.lumine.mythic.core.utils.math.Functions;
import net.objecthunter.exp4j.ExpressionBuilder;

public class PlaceholderDoubleImpl
extends PlaceholderParser
implements PlaceholderDouble {
    public PlaceholderDoubleImpl(String string) {
        super(string);
        if (string != null && string.startsWith("=")) {
            this.doMath = true;
        }
    }

    @Override
    public double get() {
        String string = this.strValue;
        if (this.papi) {
            string = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        if (this.doMath) {
            try {
                return new ExpressionBuilder(string).functions(Functions.functions).build().evaluate();
            }
            catch (Exception ex) {
                MythicLogger.error("Invalid math operation on PlaceholderString: " + this.strValue);
                ex.printStackTrace();
            }
        }
        return Double.valueOf(string);
    }

    @Override
    public double get(PlaceholderMeta meta) {
        return this.get(meta, meta == null ? null : meta.getTrigger());
    }

    @Override
    public double get(AbstractEntity entity) {
        return this.get(null, entity);
    }

    @Override
    public double get(PlaceholderMeta meta, AbstractEntity entity) {
        String string = this.parse(meta, entity);
        if (this.papi) {
            string = entity != null && entity.isPlayer() ? MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string, entity.asPlayer()) : MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        if (this.doMath) {
            try {
                return new ExpressionBuilder(string).functions(Functions.functions).build().evaluate();
            }
            catch (Exception ex) {
                MythicLogger.error("Invalid math operation on PlaceholderString: " + this.strValue);
                ex.printStackTrace();
            }
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException ex) {
            return 1.0;
        }
    }

    @Override
    public double get(SkillCaster caster) {
        return this.get(new GenericPlaceholderMeta(caster, caster.getEntity()));
    }

    public String toString() {
        return this.strValue;
    }

    public static PlaceholderDoubleImpl of(String string) {
        try {
            if (io.lumine.mythic.utils.numbers.RandomDouble.matches(string)) {
                return new RandomDouble(string);
            }
            if (string.matches("-?\\d?\\.?\\d*")) {
                return new StaticDouble(string);
            }
            if (!MythicBukkit.isVolatile()) {
                MythicLogger.error("Failed to parse Placeholder '" + string + "': Math and variables in numeric values require premium! Consider getting MythicMobs Premium at www.mythiccraft.io");
                return new StaticDouble("1");
            }
            return new PlaceholderDoubleImpl(string);
        }
        catch (Exception exception) {
            MythicLogger.error("Failed to parse Placeholder '" + string + "': invalid syntax.");
            return new StaticDouble("1");
        }
    }

    @Override
    public boolean isStaticallyEqualTo(double value) {
        return this.isStatic() && this.get() == value;
    }
}

