/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.RandomUtil;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import io.lumine.mythic.utils.numbers.Numbers;
import java.util.Collection;
import java.util.HashSet;

@MythicTargeter(author="Ashijin", name="cone", aliases={}, description="Targets random points in a cone in front of the caster")
public class ConeTargeter
extends ILocationSelector {
    protected double angle;
    protected double range;
    protected int points;
    protected double rotation;
    protected double yOffset;
    protected double cos;
    protected double cosSq;

    public ConeTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.angle = mlc.getDouble(new String[]{"angle", "a"}, 90.0);
        this.range = mlc.getDouble(new String[]{"range", "r"}, 16.0);
        this.points = mlc.getInteger(new String[]{"points", "p"}, (int)(this.angle * this.range / 10.0));
        this.rotation = mlc.getDouble(new String[]{"rotation", "rot"}, 0.0);
        this.yOffset = mlc.getDouble(new String[]{"yoffset", "yo", "y"}, 0.0);
        this.cos = Math.cos(this.angle * Math.PI / 180.0);
        this.cosSq = this.cos * this.cos;
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        AbstractLocation sourceLocation = data.getCaster().getLocation().add(0.0, this.yOffset, 0.0);
        AbstractVector dir = sourceLocation.getDirection();
        if (this.rotation > 0.0) {
            dir.rotate((float)this.rotation);
        }
        dir.setY(0);
        for (int i = 0; i < this.points; ++i) {
            AbstractVector vector = RandomUtil.getRandomVector().multiply(Numbers.randomDouble() * this.range);
            AbstractLocation location = sourceLocation.clone().add(vector);
            AbstractVector relative = location.clone().subtract(sourceLocation).toVector().setY(0);
            double dot = relative.getX() * dir.getX() + relative.getY() * dir.getY() + relative.getZ() * dir.getZ();
            double value = dot * dot / relative.lengthSquared();
            if (this.angle < 180.0 && dot > 0.0 && value >= this.cosSq) {
                targets.add(location);
                continue;
            }
            if (!(this.angle >= 180.0) || !(dot > 0.0) && !(dot <= this.cosSq)) continue;
            targets.add(location);
        }
        return targets;
    }
}

