/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.entity.Player;

@MythicTargeter(author="Ashijin", name="targetLocation", aliases={"targetLoc", "TL"}, description="Targets the location the caster is targeting")
public class TargetLocationTargeter
extends ILocationSelector {
    private int maxDistance;
    private boolean ignoreTransparent;

    public TargetLocationTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.maxDistance = mlc.getInteger(new String[]{"maxdistance", "max", "distance", "d"}, 64);
        this.ignoreTransparent = mlc.getBoolean(new String[]{"ignoreTransparent", "it"}, true);
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        SkillCaster caster = data.getCaster();
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        AbstractLocation l = null;
        if (caster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)caster;
            if (am.hasThreatTable()) {
                if (am.getThreatTable().getTopThreatHolder() != null) {
                    l = am.getThreatTable().getTopThreatHolder().getLocation();
                }
            } else if (am.getEntity().isCreature()) {
                if (am.getEntity().getTarget() != null) {
                    l = am.getEntity().getTarget().getLocation();
                }
            } else {
                l = am.getLastAggroCause().getLocation();
            }
        } else if (caster.getEntity().isPlayer()) {
            l = this.ignoreTransparent ? BukkitAdapter.adapt(((Player)BukkitAdapter.adapt(data.getCaster().getEntity())).getTargetBlock(MythicBukkit.inst().getConfiguration().getTransparentBlocks(), this.maxDistance).getLocation()) : BukkitAdapter.adapt(((Player)BukkitAdapter.adapt(data.getCaster().getEntity())).getTargetBlock(this.maxDistance).getLocation());
        }
        if (l != null) {
            targets.add(this.mutate(data, l));
        }
        return targets;
    }
}

