/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.variables.VariableScope;

public abstract class VariableCondition
extends SkillCondition {
    protected String key;
    protected VariableScope scope = VariableScope.SKILL;

    public VariableCondition(String line, MythicLineConfig mlc) {
        super(line);
        try {
            this.key = mlc.getString(new String[]{"name", "n", "variable", "var", "key", "k"}, this.conditionVar, new String[0]);
        }
        catch (Exception ex) {
            MythicLogger.errorConditionConfig(this, mlc, "Variable name must be set.");
            return;
        }
        if (this.key == null) {
            MythicLogger.errorConditionConfig(this, mlc, "Variable name must be set.");
            return;
        }
        String prefixVar = VariableScope.SKILL.toString();
        if (this.key.contains(".")) {
            String[] split = this.key.split("\\.");
            prefixVar = split[0].toUpperCase();
            this.key = split[1];
        }
        String strScope = mlc.getString(new String[]{"scope", "s"}, prefixVar, new String[0]);
        try {
            this.scope = VariableScope.valueOf(strScope.toUpperCase());
        }
        catch (Exception ex) {
            MythicLogger.errorConditionConfig(this, mlc, "'" + strScope + "' is not a valid variable scope.");
        }
    }
}

