/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import com.google.common.base.Preconditions;
import io.lumine.mythic.core.skills.variables.Variable;
import java.util.List;

public class StringListVariable
extends Variable {
    private final List<String> values;

    public StringListVariable(List<String> value) {
        Preconditions.checkNotNull(value);
        this.values = value;
    }

    @Override
    public Object get() {
        return this.values;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.values.size(); ++i) {
            builder.append(this.values.get(i));
            if (i >= this.values.size() - 1) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public List<String> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringListVariable)) {
            return false;
        }
        StringListVariable other = (StringListVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$values = this.getValues();
        List<String> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringListVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }
}

