/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_12_R1;

import com.google.common.base.Predicate;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileAIHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.config.ConfigManager;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.ai.Pathfinder;
import io.lumine.mythic.core.mobs.ai.PathfinderAdapter;
import io.lumine.mythic.core.mobs.ai.WrappedPathfinder;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicAIGoal;
import io.lumine.mythic.core.utils.reflections.VersionCompliantReflections;
import io.lumine.mythic.core.volatilecode.v1_12_R1.ai.PathfinderHolder;
import io.lumine.mythic.utils.numbers.Numbers;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.v1_12_R1.EntityCreature;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.EntityInsentient;
import net.minecraft.server.v1_12_R1.EntityIronGolem;
import net.minecraft.server.v1_12_R1.EntityLiving;
import net.minecraft.server.v1_12_R1.EntityMonster;
import net.minecraft.server.v1_12_R1.EntitySkeleton;
import net.minecraft.server.v1_12_R1.EntityTameableAnimal;
import net.minecraft.server.v1_12_R1.EntityVillager;
import net.minecraft.server.v1_12_R1.EntityWolf;
import net.minecraft.server.v1_12_R1.IMonster;
import net.minecraft.server.v1_12_R1.IRangedEntity;
import net.minecraft.server.v1_12_R1.PathfinderGoal;
import net.minecraft.server.v1_12_R1.PathfinderGoalArrowAttack;
import net.minecraft.server.v1_12_R1.PathfinderGoalAvoidTarget;
import net.minecraft.server.v1_12_R1.PathfinderGoalBowShoot;
import net.minecraft.server.v1_12_R1.PathfinderGoalBreakDoor;
import net.minecraft.server.v1_12_R1.PathfinderGoalEatTile;
import net.minecraft.server.v1_12_R1.PathfinderGoalFleeSun;
import net.minecraft.server.v1_12_R1.PathfinderGoalFloat;
import net.minecraft.server.v1_12_R1.PathfinderGoalHurtByTarget;
import net.minecraft.server.v1_12_R1.PathfinderGoalLeapAtTarget;
import net.minecraft.server.v1_12_R1.PathfinderGoalLookAtPlayer;
import net.minecraft.server.v1_12_R1.PathfinderGoalMeleeAttack;
import net.minecraft.server.v1_12_R1.PathfinderGoalMoveIndoors;
import net.minecraft.server.v1_12_R1.PathfinderGoalMoveThroughVillage;
import net.minecraft.server.v1_12_R1.PathfinderGoalMoveTowardsRestriction;
import net.minecraft.server.v1_12_R1.PathfinderGoalMoveTowardsTarget;
import net.minecraft.server.v1_12_R1.PathfinderGoalNearestAttackableTarget;
import net.minecraft.server.v1_12_R1.PathfinderGoalOpenDoor;
import net.minecraft.server.v1_12_R1.PathfinderGoalPanic;
import net.minecraft.server.v1_12_R1.PathfinderGoalRandomFly;
import net.minecraft.server.v1_12_R1.PathfinderGoalRandomLookaround;
import net.minecraft.server.v1_12_R1.PathfinderGoalRandomStroll;
import net.minecraft.server.v1_12_R1.PathfinderGoalRestrictOpenDoor;
import net.minecraft.server.v1_12_R1.PathfinderGoalRestrictSun;
import net.minecraft.server.v1_12_R1.PathfinderGoalSelector;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftLivingEntity;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityTargetEvent;

public class VolatileAIHandler_v1_12_R1
implements VolatileAIHandler {
    private final Map<String, Class<? extends PathfinderAdapter>> AI_GOALS = new ConcurrentHashMap<String, Class<? extends PathfinderAdapter>>();
    private final Map<String, Class<? extends PathfinderAdapter>> AI_TARGETS = new ConcurrentHashMap<String, Class<? extends PathfinderAdapter>>();

    public VolatileAIHandler_v1_12_R1(VolatileCodeHandler handler) {
        Set<Class<?>> customGoalClasses = new VersionCompliantReflections("io.lumine.mythic.core.mobs.ai.goals").getTypesAnnotatedWith(MythicAIGoal.class);
        for (Class<?> clazz : customGoalClasses) {
            try {
                String string = clazz.getAnnotation(MythicAIGoal.class).name();
                String[] stringArray = clazz.getAnnotation(MythicAIGoal.class).aliases();
                if (!PathfinderAdapter.class.isAssignableFrom(clazz)) continue;
                this.AI_GOALS.put(string.toUpperCase(), clazz);
                for (String alias : stringArray) {
                    this.AI_GOALS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception exception) {
                MythicLogger.error("Failed to load custom AI goal {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> wrappedGoalClasses = new VersionCompliantReflections("io.lumine.mythic.core.volatilecode.v1_12_R1.ai.goals").getTypesAnnotatedWith(MythicAIGoal.class);
        for (Class<?> clazz : wrappedGoalClasses) {
            try {
                String string = clazz.getAnnotation(MythicAIGoal.class).name();
                String[] aliases = clazz.getAnnotation(MythicAIGoal.class).aliases();
                if (!PathfinderAdapter.class.isAssignableFrom(clazz)) continue;
                this.AI_GOALS.put(string.toUpperCase(), clazz);
                for (String alias : aliases) {
                    this.AI_GOALS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception exception) {
                MythicLogger.error("Failed to load wrapped AI goal {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> set = new VersionCompliantReflections("io.lumine.mythic.core.mobs.ai.targeters").getTypesAnnotatedWith(MythicAIGoal.class);
        for (Class<?> clazz : set) {
            try {
                String name = clazz.getAnnotation(MythicAIGoal.class).name();
                String[] aliases = clazz.getAnnotation(MythicAIGoal.class).aliases();
                if (!PathfinderAdapter.class.isAssignableFrom(clazz)) continue;
                this.AI_TARGETS.put(name.toUpperCase(), clazz);
                for (String alias : aliases) {
                    this.AI_TARGETS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load custom AI targeter {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> set2 = new VersionCompliantReflections("io.lumine.mythic.core.volatilecode.v1_12_R1.ai.targeters").getTypesAnnotatedWith(MythicAIGoal.class);
        for (Class<?> clazz : set2) {
            try {
                String name = clazz.getAnnotation(MythicAIGoal.class).name();
                String[] aliases = clazz.getAnnotation(MythicAIGoal.class).aliases();
                if (!PathfinderAdapter.class.isAssignableFrom(clazz)) continue;
                this.AI_TARGETS.put(name.toUpperCase(), clazz);
                for (String alias : aliases) {
                    this.AI_TARGETS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load wrapped AI targeter {0}", clazz.getCanonicalName());
            }
        }
    }

    @Override
    public void setTarget(LivingEntity entity, LivingEntity target) {
        if (entity instanceof Creature) {
            try {
                ((Creature)entity).setTarget(target);
            }
            catch (Exception exception) {}
        } else {
            try {
                ((EntityInsentient)((CraftLivingEntity)entity).getHandle()).setGoalTarget(((CraftLivingEntity)target).getHandle(), EntityTargetEvent.TargetReason.CUSTOM, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void addPathfinderGoals(LivingEntity entity, List<String> aiMods) {
        block107: {
            try {
                EntityInsentient e = (EntityInsentient)((CraftLivingEntity)entity).getHandle();
                Field goalsField = EntityInsentient.class.getDeclaredField("goalSelector");
                goalsField.setAccessible(true);
                PathfinderGoalSelector goals = (PathfinderGoalSelector)goalsField.get(e);
                int i = 0;
                int j = 0;
                block87: for (String str : aiMods) {
                    String data2;
                    String data;
                    String goal;
                    ++i;
                    String[] split = str.split(" ");
                    if (split[0].matches("[0-9]*")) {
                        j = Integer.parseInt(split[0]);
                        goal = split[1];
                        data = split.length > 2 ? split[2] : null;
                        data2 = split.length > 3 ? split[3] : null;
                    } else {
                        j = i;
                        goal = split[0];
                        data = split.length > 1 ? split[1] : null;
                        data2 = split.length > 2 ? split[2] : null;
                    }
                    MythicLineConfigImpl mlc = new MythicLineConfigImpl(goal);
                    goal = mlc.getKey();
                    if (this.AI_GOALS.containsKey(goal.toUpperCase())) {
                        Class<? extends PathfinderAdapter> clazz = this.AI_GOALS.get(goal.toUpperCase());
                        try {
                            if (clazz.isAssignableFrom(Pathfinder.class)) {
                                Pathfinder pathfinder = (Pathfinder)clazz.getConstructor(AbstractEntity.class, String.class, MythicLineConfig.class).newInstance(BukkitAdapter.adapt((Entity)entity), str, mlc);
                                goals.a(j, this.createAIGoal(pathfinder));
                                continue;
                            }
                            WrappedPathfinder wrappedPathfinder = (WrappedPathfinder)((Object)clazz.getConstructor(AbstractEntity.class, String.class, MythicLineConfig.class).newInstance(BukkitAdapter.adapt((Entity)entity), str, mlc));
                            PathfinderHolder holder = (PathfinderHolder)((Object)wrappedPathfinder);
                            if (holder.isValid()) {
                                PathfinderGoal pathfinder = holder.create();
                                goals.a(j, pathfinder);
                                continue;
                            }
                            MythicLogger.error("AI pathfinder {0} is not valid for this mob type", goal);
                            continue;
                        }
                        catch (Error | Exception ex) {
                            MythicLogger.error("Failed to construct AI pathfinder {0}", goal);
                            ex.printStackTrace();
                        }
                    }
                    switch (goal.toLowerCase()) {
                        case "reset": 
                        case "clear": {
                            Field listField = PathfinderGoalSelector.class.getDeclaredField("b");
                            listField.setAccessible(true);
                            Set list = (Set)listField.get(goals);
                            list.clear();
                            listField = PathfinderGoalSelector.class.getDeclaredField("c");
                            listField.setAccessible(true);
                            list = (Set)listField.get(goals);
                            list.clear();
                            continue block87;
                        }
                        case "arrowattack": {
                            if (!(e instanceof IRangedEntity)) continue block87;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalArrowAttack((IRangedEntity)e, 1.0, 20, 60, 15.0f));
                            continue block87;
                        }
                        case "skeletonbowattack": 
                        case "bowshoot": 
                        case "bowmaster": {
                            if (!(e instanceof IRangedEntity)) continue block87;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalBowShoot((EntityMonster)((EntitySkeleton)e), 1.0, 20, 15.0f));
                            continue block87;
                        }
                        case "breakdoor": {
                            goals.a(j, (PathfinderGoal)new PathfinderGoalBreakDoor(e));
                            continue block87;
                        }
                        case "eatgrass": {
                            goals.a(j, (PathfinderGoal)new PathfinderGoalEatTile(e));
                            continue block87;
                        }
                        case "fleegolems": 
                        case "runfromgolems": {
                            if (!(e instanceof EntityCreature)) continue block87;
                            float distance = 16.0f;
                            double speed = 1.2;
                            if (data != null) {
                                distance = Float.valueOf(data).floatValue();
                            }
                            if (data2 != null) {
                                speed = Float.valueOf(data2).floatValue();
                            }
                            goals.a(j, (PathfinderGoal)new PathfinderGoalAvoidTarget((EntityCreature)e, EntityIronGolem.class, distance, 1.0, speed));
                            continue block87;
                        }
                        case "fleeplayers": 
                        case "runfromplayers": {
                            if (!(e instanceof EntityCreature)) continue block87;
                            float distance = 16.0f;
                            double speed = 1.2;
                            if (data != null) {
                                distance = Float.valueOf(data).floatValue();
                            }
                            if (data2 != null) {
                                speed = Float.valueOf(data2).floatValue();
                            }
                            goals.a(j, (PathfinderGoal)new PathfinderGoalAvoidTarget((EntityCreature)e, EntityHuman.class, distance, 1.0, speed));
                            continue block87;
                        }
                        case "fleevillagers": 
                        case "runfromvillagers": {
                            if (!(e instanceof EntityCreature)) continue block87;
                            float distance = 16.0f;
                            double speed = 1.2;
                            if (data != null) {
                                distance = Float.valueOf(data).floatValue();
                            }
                            if (data2 != null) {
                                speed = Float.valueOf(data2).floatValue();
                            }
                            goals.a(j, (PathfinderGoal)new PathfinderGoalAvoidTarget((EntityCreature)e, EntityVillager.class, distance, 1.0, speed));
                            continue block87;
                        }
                        case "fleewolves": 
                        case "runfromwolves": {
                            if (!(e instanceof EntityCreature)) continue block87;
                            float distance = 6.0f;
                            double speed = 1.2;
                            if (data != null) {
                                distance = Float.valueOf(data).floatValue();
                            }
                            if (data2 != null) {
                                speed = Float.valueOf(data2).floatValue();
                            }
                            goals.a(j, (PathfinderGoal)new PathfinderGoalAvoidTarget((EntityCreature)e, EntityWolf.class, distance, 1.0, speed));
                            continue block87;
                        }
                        case "fleesun": {
                            if (!(e instanceof EntityCreature)) continue block87;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalFleeSun((EntityCreature)e, 1.0));
                            continue block87;
                        }
                        case "float": 
                        case "swim": {
                            goals.a(j, (PathfinderGoal)new PathfinderGoalFloat(e));
                            continue block87;
                        }
                        case "gotolocation": 
                        case "goto": {
                            try {
                                String[] sp = data.split(",");
                                int x = Integer.valueOf(sp[0]);
                                int y = Integer.valueOf(sp[1]);
                                int z = Integer.valueOf(sp[2]);
                                float speed = 1.0f;
                                if (data2 != null) {
                                    speed = Float.valueOf(data2).floatValue();
                                }
                                AbstractLocation l = new AbstractLocation(BukkitAdapter.adapt(entity.getWorld()), x, y, z);
                                goals.a(j, (PathfinderGoal)new PathfinderGoalGoToLocation(e, l, speed));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            continue block87;
                        }
                        case "gotoowner": {
                            try {
                                float distance = 4.0f;
                                if (data != null) {
                                    distance = Float.valueOf(data2).floatValue();
                                }
                                goals.a(j, (PathfinderGoal)new PathfinderGoalGoToOwner(e, distance * distance));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            continue block87;
                        }
                        case "gotoparent": {
                            try {
                                float distance = 4.0f;
                                if (data != null) {
                                    distance = Float.valueOf(data2).floatValue();
                                }
                                goals.a(j, (PathfinderGoal)new PathfinderGoalGoToParent(e, distance * distance));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            continue block87;
                        }
                        case "lookatplayers": {
                            goals.a(j, (PathfinderGoal)new PathfinderGoalLookAtPlayer(e, EntityHuman.class, 5.0f, 1.0f));
                            continue block87;
                        }
                        case "leapattarget": {
                            float speed = 0.3f;
                            if (data != null) {
                                speed = Float.valueOf(data).floatValue();
                            }
                            goals.a(j, (PathfinderGoal)new PathfinderGoalLeapAtTarget(e, speed));
                            continue block87;
                        }
                        case "spiderattack": {
                            if (!(e instanceof EntityCreature)) continue block87;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalSpiderMeleeAttack((EntityCreature)e, EntityCreature.class));
                            continue block87;
                        }
                        case "moveindoors": {
                            if (!(e instanceof EntityCreature)) continue block87;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalMoveIndoors((EntityCreature)e));
                            continue block87;
                        }
                        case "movethroughvillage": {
                            if (!(e instanceof EntityCreature)) continue block87;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalMoveThroughVillage((EntityCreature)e, 0.6, true));
                            continue block87;
                        }
                        case "movetowardsrestriction": {
                            if (!(e instanceof EntityCreature)) continue block87;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalMoveTowardsRestriction((EntityCreature)e, 0.6));
                            continue block87;
                        }
                        case "movetowardstarget": {
                            if (!(e instanceof EntityCreature)) continue block87;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalMoveTowardsTarget((EntityCreature)e, 0.9, 32.0f));
                            continue block87;
                        }
                        case "opendoor": 
                        case "opendoors": {
                            goals.a(j, (PathfinderGoal)new PathfinderGoalOpenDoor(e, true));
                            continue block87;
                        }
                        case "panic": {
                            if (!(e instanceof EntityCreature)) continue block87;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalPanic((EntityCreature)e, 1.25));
                            continue block87;
                        }
                        case "patrol": 
                        case "patrolroute": {
                            try {
                                String[] split2;
                                ArrayList<AbstractLocation> points = new ArrayList<AbstractLocation>();
                                for (String s2 : split2 = data.split(";")) {
                                    String[] split3 = s2.split(",");
                                    int x = Integer.valueOf(split3[0]);
                                    int y = Integer.valueOf(split3[1]);
                                    int z = Integer.valueOf(split3[2]);
                                    AbstractLocation l = new AbstractLocation(BukkitAdapter.adapt(entity.getWorld()), x, y, z);
                                    points.add(l);
                                }
                                float speed2 = 1.0f;
                                if (data2 != null) {
                                    float f = Float.valueOf(data2).floatValue();
                                }
                                goals.a(j, (PathfinderGoal)new PathfinderGoalPatrolRoute(e, points, speed2));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            continue block87;
                        }
                        case "randomlookaround": 
                        case "lookaround": {
                            goals.a(j, (PathfinderGoal)new PathfinderGoalRandomLookaround(e));
                            continue block87;
                        }
                        case "randomstroll": {
                            if (!(e instanceof EntityCreature)) continue block87;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalRandomStroll((EntityCreature)e, 1.0));
                            continue block87;
                        }
                        case "randomfly": {
                            if (!(e instanceof EntityCreature)) continue block87;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalRandomFly((EntityCreature)e, 1.0));
                            continue block87;
                        }
                        case "restrictopendoor": 
                        case "closedoors": {
                            if (!(e instanceof EntityCreature)) continue block87;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalRestrictOpenDoor((EntityCreature)e));
                            continue block87;
                        }
                        case "restrictsun": {
                            if (!(e instanceof EntityCreature)) continue block87;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalRestrictSun((EntityCreature)e));
                            continue block87;
                        }
                    }
                }
            }
            catch (Exception ex) {
                MythicLogger.error("An error occurred while adding an AIGoalSelector, enable debugging for a stack trace.");
                if (ConfigManager.debugLevel <= 0) break block107;
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void addTargetGoals(LivingEntity entity, List<String> aiMods) {
        block39: {
            try {
                EntityInsentient e = (EntityInsentient)((CraftLivingEntity)entity).getHandle();
                Field goalsField = EntityInsentient.class.getDeclaredField("targetSelector");
                goalsField.setAccessible(true);
                PathfinderGoalSelector goals = (PathfinderGoalSelector)goalsField.get(e);
                int i = 0;
                int j = 0;
                block33: for (String str : aiMods) {
                    String data;
                    String goal;
                    ++i;
                    String[] split = str.split(" ");
                    if (split[0].matches("[0-9]*")) {
                        j = Integer.parseInt(split[0]);
                        goal = split[1];
                        data = split.length > 2 ? split[2] : "";
                    } else {
                        j = i;
                        goal = split[0];
                        data = split.length > 1 ? split[1] : "";
                    }
                    MythicLineConfigImpl mlc = new MythicLineConfigImpl(goal);
                    goal = mlc.getKey();
                    if (this.AI_TARGETS.containsKey(goal.toUpperCase())) {
                        Class<? extends PathfinderAdapter> clazz = this.AI_TARGETS.get(goal.toUpperCase());
                        try {
                            if (clazz.isAssignableFrom(Pathfinder.class)) {
                                Pathfinder pathfinder = (Pathfinder)clazz.getConstructor(AbstractEntity.class, String.class, MythicLineConfig.class).newInstance(BukkitAdapter.adapt((Entity)entity), str, mlc);
                                goals.a(j, this.createAIGoal(pathfinder));
                                continue;
                            }
                            WrappedPathfinder wrappedPathfinder = (WrappedPathfinder)((Object)clazz.getConstructor(AbstractEntity.class, String.class, MythicLineConfig.class).newInstance(BukkitAdapter.adapt((Entity)entity), str, mlc));
                            PathfinderHolder holder = (PathfinderHolder)((Object)wrappedPathfinder);
                            if (holder.isValid()) {
                                PathfinderGoal pathfinder = holder.create();
                                goals.a(j, pathfinder);
                                continue;
                            }
                            MythicLogger.error("AI pathfinder {0} is not valid for this mob type", goal);
                            continue;
                        }
                        catch (Error | Exception ex) {
                            MythicLogger.error("Failed to construct AI pathfinder {0}", goal);
                            ex.printStackTrace();
                        }
                    }
                    switch (goal.toLowerCase()) {
                        case "reset": 
                        case "clear": {
                            Field listField = PathfinderGoalSelector.class.getDeclaredField("b");
                            listField.setAccessible(true);
                            Set list = (Set)listField.get(goals);
                            list.clear();
                            listField = PathfinderGoalSelector.class.getDeclaredField("c");
                            listField.setAccessible(true);
                            list = (Set)listField.get(goals);
                            list.clear();
                            continue block33;
                        }
                        case "ownerhurttarget": 
                        case "ownertarget": {
                            if (!(e instanceof EntityTameableAnimal)) continue block33;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalHurtByTarget((EntityCreature)e, false, new Class[0]));
                            continue block33;
                        }
                        case "monsters": {
                            if (!(e instanceof EntityCreature)) continue block33;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityCreature)e, EntityInsentient.class, 0, true, false, IMonster.d));
                            continue block33;
                        }
                        case "players": {
                            if (!(e instanceof EntityCreature)) continue block33;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityCreature)e, EntityHuman.class, true));
                            continue block33;
                        }
                        case "villagers": {
                            if (!(e instanceof EntityCreature)) continue block33;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityCreature)e, EntityVillager.class, false));
                            continue block33;
                        }
                        case "iron_golems": 
                        case "golems": {
                            if (!(e instanceof EntityCreature)) continue block33;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableTarget((EntityCreature)e, EntityIronGolem.class, false));
                            continue block33;
                        }
                        case "otherfaction": {
                            if (!(e instanceof EntityCreature)) continue block33;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableOtherFactionTarget((EntityCreature)e, EntityInsentient.class, 0, true));
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableOtherFactionTarget((EntityCreature)e, EntityHuman.class, 0, true));
                            continue block33;
                        }
                        case "otherfactionmonsters": {
                            if (!(e instanceof EntityCreature)) continue block33;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableOtherFactionTarget((EntityCreature)e, EntityInsentient.class, 0, true, false, IMonster.d));
                            continue block33;
                        }
                        case "otherfactionvillagers": {
                            if (!(e instanceof EntityCreature)) continue block33;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableOtherFactionTarget((EntityCreature)e, EntityVillager.class, 0, false));
                            continue block33;
                        }
                        case "specificfaction": {
                            if (!(e instanceof EntityCreature)) continue block33;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableSpecificFactionTarget((EntityCreature)e, EntityInsentient.class, data, 0, false));
                            continue block33;
                        }
                        case "specificfactionmonsters": {
                            if (!(e instanceof EntityCreature)) continue block33;
                            goals.a(j, (PathfinderGoal)new PathfinderGoalNearestAttackableSpecificFactionTarget((EntityCreature)e, EntityInsentient.class, data, 0, true, false, IMonster.d));
                            continue block33;
                        }
                    }
                }
            }
            catch (Exception ex) {
                MythicLogger.error("An error has occurred, enable debugging for a stack trace.");
                if (ConfigManager.debugLevel <= 0) break block39;
                ex.printStackTrace();
            }
        }
    }

    public PathfinderGoal createAIGoal(Pathfinder goal) {
        return new CustomAIAdapter_v1_12_R1(goal);
    }

    public class PathfinderGoalGoToLocation
    extends PathfinderGoal {
        private double speed;
        private EntityInsentient entity;
        private AbstractLocation destination;

        public PathfinderGoalGoToLocation(EntityInsentient entity, AbstractLocation loc, double speed) {
            this.entity = entity;
            this.destination = loc;
            this.speed = speed;
        }

        public boolean a() {
            try {
                AbstractLocation eLocation = new AbstractLocation(this.destination.getWorld(), this.entity.locX, this.entity.locY, this.entity.locZ);
                if (eLocation.distanceSquared(this.destination) > 1.0) {
                    this.entity.getNavigation().a(this.destination.getX(), this.destination.getY(), this.destination.getZ(), this.speed);
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    public class PathfinderGoalGoToOwner
    extends PathfinderGoal {
        private double speed;
        private EntityInsentient entity;

        public PathfinderGoalGoToOwner(EntityInsentient entity, double speed) {
            this.entity = entity;
            this.speed = speed;
        }

        public boolean a() {
            try {
                ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance((Entity)((LivingEntity)this.entity.getBukkitEntity()));
                if (!am.getOwner().isPresent()) {
                    return false;
                }
                Player owner = Bukkit.getPlayer((UUID)am.getOwner().get());
                if (owner == null) {
                    return false;
                }
                AbstractLocation destination = BukkitAdapter.adapt(owner.getLocation());
                AbstractLocation eLocation = new AbstractLocation(destination.getWorld(), this.entity.locX, this.entity.locY, this.entity.locZ);
                if (eLocation.distanceSquared(destination) > 1024.0) {
                    am.getEntity().teleport(destination);
                    return true;
                }
                if (eLocation.distanceSquared(destination) > this.speed) {
                    this.entity.getNavigation().a(destination.getX(), destination.getY(), destination.getZ(), 1.0);
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
    }

    public class PathfinderGoalGoToParent
    extends PathfinderGoal {
        private double speed;
        private EntityInsentient entity;

        public PathfinderGoalGoToParent(EntityInsentient entity, double speed) {
            this.entity = entity;
            this.speed = speed;
        }

        public boolean a() {
            try {
                ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance((Entity)((LivingEntity)this.entity.getBukkitEntity()));
                if (am.getParent() == null) {
                    return false;
                }
                Entity parent = BukkitAdapter.adapt(am.getParent().getEntity());
                if (parent == null || parent.isDead() || !parent.isValid()) {
                    return false;
                }
                AbstractLocation destination = BukkitAdapter.adapt(parent.getLocation());
                AbstractLocation eLocation = new AbstractLocation(destination.getWorld(), this.entity.locX, this.entity.locY, this.entity.locZ);
                if (eLocation.distanceSquared(destination) > 1024.0) {
                    am.getEntity().teleport(destination);
                    return true;
                }
                if (eLocation.distanceSquared(destination) > this.speed) {
                    this.entity.getNavigation().a(destination.getX(), destination.getY(), destination.getZ(), 1.0);
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
    }

    static class PathfinderGoalSpiderMeleeAttack
    extends PathfinderGoalMeleeAttack {
        public PathfinderGoalSpiderMeleeAttack(EntityCreature entity, Class<? extends net.minecraft.server.v1_12_R1.Entity> oclass) {
            super(entity, 1.0, true);
        }

        public boolean b() {
            return super.b();
        }

        protected double a(EntityLiving entityliving) {
            return 4.0f + entityliving.width;
        }
    }

    public class PathfinderGoalPatrolRoute
    extends PathfinderGoal {
        private double speed;
        private EntityInsentient entity;
        private AbstractWorld world;
        private int currentDestination = -1;
        private List<AbstractLocation> points;

        public PathfinderGoalPatrolRoute(EntityInsentient entity, List<AbstractLocation> points, double speed) {
            this.entity = entity;
            this.points = points;
            this.speed = speed;
            if (points.size() == 0) {
                return;
            }
            this.world = points.get(0).getWorld();
            AbstractLocation entityLocation = new AbstractLocation(this.world, entity.locX, entity.locY, entity.locZ);
            int best = 0;
            double d = points.get(0).distanceSquared(entityLocation);
            for (int i = 1; i < points.size(); ++i) {
                double x = points.get(i).distanceSquared(entityLocation);
                if (!(x < d)) continue;
                best = i;
                d = x;
            }
            this.currentDestination = best;
        }

        public boolean a() {
            if (this.points.size() < 2) {
                return false;
            }
            AbstractLocation eLocation = new AbstractLocation(this.world, this.entity.locX, this.entity.locY, this.entity.locZ);
            AbstractLocation currentTarget = this.points.get(this.currentDestination);
            if (eLocation.distanceSquared(currentTarget) > 1.0) {
                this.entity.getNavigation().a(currentTarget.getX(), currentTarget.getY(), currentTarget.getZ(), this.speed);
                return true;
            }
            if (++this.currentDestination == this.points.size()) {
                this.currentDestination = 0;
            }
            AbstractLocation newTarget = this.points.get(this.currentDestination);
            this.entity.getNavigation().a(newTarget.getX(), newTarget.getY(), newTarget.getZ(), this.speed);
            return true;
        }
    }

    public class PathfinderGoalNearestAttackableOtherFactionTarget
    extends PathfinderGoalNearestAttackableTarget {
        public PathfinderGoalNearestAttackableOtherFactionTarget(EntityCreature entitycreature, Class oclass, int i, boolean flag) {
            this(entitycreature, oclass, i, flag, false);
        }

        public PathfinderGoalNearestAttackableOtherFactionTarget(EntityCreature entitycreature, Class oclass, int i, boolean flag, boolean flag1) {
            this(entitycreature, oclass, i, flag, flag1, null);
        }

        public PathfinderGoalNearestAttackableOtherFactionTarget(EntityCreature entitycreature, Class oclass, int i, boolean flag, boolean flag1, Predicate ientityselector) {
            super(entitycreature, oclass, i, flag, flag1, ientityselector);
        }

        public boolean a() {
            int pB = (Integer)MythicUtil.getPrivateField("i", PathfinderGoalNearestAttackableTarget.class, (Object)this);
            if (pB > 0 && Numbers.randomInt(pB) != 0) {
                return false;
            }
            List list = this.e.world.a(this.a, this.a(this.i()), this.c);
            if (list.isEmpty()) {
                return false;
            }
            Collections.sort(list, this.b);
            ActiveMob am = MythicBukkit.inst().getMobManager().getMythicMobInstance((Entity)((LivingEntity)this.e.getBukkitEntity()));
            if (am.hasFaction()) {
                for (int i = 0; i < list.size(); ++i) {
                    EntityLiving el = (EntityLiving)list.get(i);
                    if (MythicBukkit.inst().getMobManager().isActiveMob(el.getBukkitEntity().getUniqueId()) && MythicBukkit.inst().getMobManager().getMythicMobInstance((Entity)((LivingEntity)el.getBukkitEntity())).hasFaction()) {
                        if (MythicBukkit.inst().getMobManager().getMythicMobInstance((Entity)((LivingEntity)el.getBukkitEntity())).getFaction().equals(am.getFaction())) continue;
                        MythicUtil.setPrivateField("d", PathfinderGoalNearestAttackableTarget.class, (Object)this, el);
                        return true;
                    }
                    MythicUtil.setPrivateField("d", PathfinderGoalNearestAttackableTarget.class, (Object)this, el);
                    return true;
                }
                return false;
            }
            MythicUtil.setPrivateField("d", PathfinderGoalNearestAttackableTarget.class, (Object)this, (EntityLiving)list.get(0));
            return true;
        }
    }

    public class PathfinderGoalNearestAttackableSpecificFactionTarget
    extends PathfinderGoalNearestAttackableTarget {
        private final String faction;

        public PathfinderGoalNearestAttackableSpecificFactionTarget(EntityCreature entitycreature, Class oclass, String faction, int i, boolean flag) {
            this(entitycreature, oclass, faction, i, flag, false);
        }

        public PathfinderGoalNearestAttackableSpecificFactionTarget(EntityCreature entitycreature, Class oclass, String faction, int i, boolean flag, boolean flag1) {
            this(entitycreature, oclass, faction, i, flag, flag1, null);
        }

        public PathfinderGoalNearestAttackableSpecificFactionTarget(EntityCreature entitycreature, Class oclass, String faction, int i, boolean flag, boolean flag1, Predicate ientityselector) {
            super(entitycreature, oclass, i, flag, flag1, ientityselector);
            this.faction = faction;
        }

        public boolean a() {
            int pB = (Integer)MythicUtil.getPrivateField("i", PathfinderGoalNearestAttackableTarget.class, (Object)this);
            if (pB > 0 && Numbers.randomInt(pB) != 0) {
                return false;
            }
            List list = this.e.world.a(this.a, this.a(this.i()), this.c);
            list.remove(this.c);
            if (list.isEmpty()) {
                return false;
            }
            Collections.sort(list, this.b);
            for (int i = 0; i < list.size(); ++i) {
                EntityLiving el = (EntityLiving)list.get(i);
                if (!MythicBukkit.inst().getMobManager().isActiveMob(el.getBukkitEntity().getUniqueId()) || !MythicBukkit.inst().getMobManager().getMythicMobInstance((Entity)((LivingEntity)el.getBukkitEntity())).hasFaction() || !MythicBukkit.inst().getMobManager().getMythicMobInstance((Entity)((LivingEntity)el.getBukkitEntity())).getFaction().equals(this.faction)) continue;
                MythicUtil.setPrivateField("d", PathfinderGoalNearestAttackableTarget.class, (Object)this, el);
                return true;
            }
            return false;
        }
    }

    public class CustomAIAdapter_v1_12_R1
    extends PathfinderGoal
    implements PathfinderAdapter {
        private final Pathfinder goal;

        @Override
        public boolean isValid() {
            return this.goal.isValid();
        }

        public boolean a() {
            try {
                return this.goal.shouldStart();
            }
            catch (Error | Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        public void c() {
            try {
                this.goal.start();
            }
            catch (Error | Exception e) {
                e.printStackTrace();
            }
        }

        public void e() {
            try {
                this.goal.tick();
            }
            catch (Error | Exception e) {
                e.printStackTrace();
            }
        }

        public boolean b() {
            try {
                return !this.goal.shouldEnd();
            }
            catch (Error | Exception e) {
                e.printStackTrace();
                return true;
            }
        }

        public void d() {
            try {
                this.goal.end();
            }
            catch (Error | Exception e) {
                e.printStackTrace();
            }
        }

        public CustomAIAdapter_v1_12_R1(Pathfinder goal) {
            this.goal = goal;
        }

        public Pathfinder getGoal() {
            return this.goal;
        }
    }
}

